/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.tools;

import com.rapidminer.gui.RapidMinerGUI;
import com.rapidminer.gui.dialog.SearchDialog;
import com.rapidminer.gui.dialog.SearchableJTextComponent;
import com.rapidminer.gui.tools.ExtendedJScrollPane;
import com.rapidminer.gui.tools.IconSize;
import com.rapidminer.gui.tools.LoggingViewerOutputStream;
import com.rapidminer.gui.tools.SwingTools;
import com.rapidminer.gui.tools.actions.ClearMessageAction;
import com.rapidminer.gui.tools.actions.LoggingSearchAction;
import com.rapidminer.gui.tools.actions.SaveLogFileAction;
import com.rapidminer.parameter.UndefinedParameterError;
import java.awt.Component;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import javax.swing.Action;
import javax.swing.JPopupMenu;
import javax.swing.JTextPane;

public class LoggingViewer
extends ExtendedJScrollPane
implements MouseListener {
    private static final long serialVersionUID = 551259537624386372L;
    public transient LoggingViewerOutputStream outputStream;
    public final transient Action CLEAR_MESSAGE_VIEWER_ACTION_24 = new ClearMessageAction(this, IconSize.SMALL);
    public final transient Action CLEAR_MESSAGE_VIEWER_ACTION_32 = new ClearMessageAction(this, IconSize.MIDDLE);
    public final transient Action SAVE_LOGFILE_ACTION_24 = new SaveLogFileAction(this, IconSize.SMALL);
    public final transient Action SAVE_LOGFILE_ACTION_32 = new SaveLogFileAction(this, IconSize.MIDDLE);
    public final transient Action SEARCH_ACTION_24 = new LoggingSearchAction(this, IconSize.SMALL);
    public final transient Action SEARCH_ACTION_32 = new LoggingSearchAction(this, IconSize.MIDDLE);
    private JTextPane textArea;

    public LoggingViewer() {
        this(new JTextPane());
    }

    private LoggingViewer(JTextPane textArea) {
        super(textArea);
        this.textArea = textArea;
        this.textArea.setToolTipText("Displays logging messages according to the current log verbosity (parameter of root operator).");
        this.textArea.setEditable(false);
        this.textArea.addMouseListener(this);
        this.textArea.setFont(this.textArea.getFont().deriveFont(0));
        this.outputStream = new LoggingViewerOutputStream(this.textArea);
    }

    protected Object readResolve() {
        this.outputStream = new LoggingViewerOutputStream(this.textArea);
        return this;
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void mouseReleased(MouseEvent e) {
        this.evaluatePopup(e);
    }

    public void mousePressed(MouseEvent e) {
        this.evaluatePopup(e);
    }

    private void evaluatePopup(MouseEvent e) {
        if (e.isPopupTrigger()) {
            this.createPopupMenu().show(this.textArea, e.getX(), e.getY());
        }
    }

    private JPopupMenu createPopupMenu() {
        JPopupMenu menu = new JPopupMenu();
        menu.add(this.CLEAR_MESSAGE_VIEWER_ACTION_24);
        menu.add(this.SAVE_LOGFILE_ACTION_24);
        menu.add(this.SEARCH_ACTION_24);
        return menu;
    }

    public String getLogMessage() {
        return this.textArea.getText();
    }

    public void clear() {
        this.outputStream.clear();
        this.textArea.setText("");
    }

    public void saveLog() {
        File file = new File("." + File.separator);
        String logFile = null;
        try {
            logFile = RapidMinerGUI.getMainFrame().getProcess().getRootOperator().getParameterAsString("logfile");
        }
        catch (UndefinedParameterError undefinedParameterError) {
            // empty catch block
        }
        if (logFile != null) {
            file = RapidMinerGUI.getMainFrame().getProcess().resolveFileName(logFile);
        } else {
            file = RapidMinerGUI.getMainFrame().getProcess().getProcessFile();
            if (file != null) {
                file = file.getParentFile();
            }
        }
        file = SwingTools.chooseFile((Component)this, file, false, "log", "log file");
        if (file != null) {
            PrintWriter out = null;
            try {
                try {
                    out = new PrintWriter(new FileWriter(file));
                    out.println(this.textArea.getText());
                }
                catch (IOException ex) {
                    SwingTools.showSimpleErrorMessage("Cannot write log file.", ex);
                    if (out != null) {
                        out.close();
                    }
                }
            }
            finally {
                if (out != null) {
                    out.close();
                }
            }
        }
    }

    public void performSearch() {
        new SearchDialog(this, new SearchableJTextComponent(this.textArea)).setVisible(true);
    }
}

