/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator;

import com.rapidminer.generator.GenerationException;
import com.rapidminer.operator.IOObject;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.UserError;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeBoolean;
import com.rapidminer.parameter.ParameterTypeList;
import com.rapidminer.parameter.ParameterTypeString;
import com.rapidminer.tools.math.function.ExpressionParser;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MacroConstructionOperator
extends Operator {
    public static final String PARAMETER_FUNCTIONS = "function_descriptions";
    public static final String PARAMETER_USE_STANDARD_CONSTANTS = "use_standard_constants";

    public MacroConstructionOperator(OperatorDescription description) {
        super(description);
    }

    @Override
    public IOObject[] apply() throws OperatorException {
        ExpressionParser parser = new ExpressionParser(this.getParameterAsBoolean(PARAMETER_USE_STANDARD_CONSTANTS));
        for (String[] nameFunctionPair : this.getParameterList(PARAMETER_FUNCTIONS)) {
            String name = nameFunctionPair[0];
            String function = nameFunctionPair[1];
            try {
                parser.addMacro(this.getProcess().getMacroHandler(), name, function);
            }
            catch (GenerationException e) {
                throw new UserError((Operator)this, 108, e.getMessage());
            }
        }
        return new IOObject[0];
    }

    @Override
    public Class<?>[] getInputClasses() {
        return new Class[0];
    }

    @Override
    public Class<?>[] getOutputClasses() {
        return new Class[0];
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        ParameterTypeList type = new ParameterTypeList(PARAMETER_FUNCTIONS, "The list of macro names together with the expressions which define the new macros", new ParameterTypeString("functions_expressions", "The expressions which define the new macros.", false));
        type.setExpert(false);
        types.add(type);
        types.add(new ParameterTypeBoolean(PARAMETER_USE_STANDARD_CONSTANTS, "Indicates if standard constants like e or pi should be available.", true));
        return types;
    }
}

