/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.features.construction;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.generator.FeatureGenerator;
import com.rapidminer.generator.SinusFactory;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.features.construction.ExampleSetBasedPopulationOperator;
import com.rapidminer.operator.features.construction.FourierGeneratingMutation;
import com.rapidminer.operator.features.construction.FourierGenerator;
import com.rapidminer.operator.features.construction.YAGGA2;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeCategory;
import com.rapidminer.parameter.ParameterTypeDouble;
import com.rapidminer.parameter.ParameterTypeInt;
import com.rapidminer.parameter.ParameterTypeString;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FourierGGA
extends YAGGA2 {
    public static final String PARAMETER_NUMBER_ORIGINAL = "number_original";
    public static final String PARAMETER_NUMBER_CONSTRUCTED = "number_constructed";
    public static final String PARAMETER_START_SINUS_BOOST = "start_sinus_boost";
    public static final String PARAMETER_SEARCH_FOURIER_PEAKS = "search_fourier_peaks";
    public static final String PARAMETER_ATTRIBUTES_PER_PEAK = "attributes_per_peak";
    public static final String PARAMETER_EPSILON = "epsilon";
    public static final String PARAMETER_ADAPTION_TYPE = "adaption_type";

    public FourierGGA(OperatorDescription description) {
        super(description);
    }

    @Override
    protected ExampleSetBasedPopulationOperator getMutationPopulationOperator(ExampleSet eSet) throws OperatorException {
        List<FeatureGenerator> generators = this.getGenerators();
        if (generators.size() == 0) {
            this.logWarning("No FeatureGenerators specified for " + this.getName() + ".");
        }
        LinkedList<Attribute> attributes = new LinkedList<Attribute>();
        for (Attribute attribute : eSet.getAttributes()) {
            attributes.add(attribute);
        }
        double pMutation = this.getParameterAsDouble("p_mutation");
        return new FourierGeneratingMutation(attributes, pMutation, generators, this.getParameterAsInt(PARAMETER_NUMBER_CONSTRUCTED), this.getParameterAsInt(PARAMETER_NUMBER_ORIGINAL), this.getParameterAsInt(PARAMETER_SEARCH_FOURIER_PEAKS), this.getParameterAsInt(PARAMETER_ADAPTION_TYPE), this.getParameterAsInt(PARAMETER_ATTRIBUTES_PER_PEAK), this.getParameterAsDouble(PARAMETER_EPSILON), this.getParameterAsString("unused_functions").split(" "), this.getRandom());
    }

    @Override
    protected List<ExampleSetBasedPopulationOperator> getPreProcessingPopulationOperators(ExampleSet eSet) throws OperatorException {
        List<ExampleSetBasedPopulationOperator> popOps = super.getPreProcessingPopulationOperators(eSet);
        int startSinus = this.getParameterAsInt(PARAMETER_START_SINUS_BOOST);
        if (startSinus > 0) {
            FourierGenerator fourierGen = new FourierGenerator(this.getParameterAsInt(PARAMETER_SEARCH_FOURIER_PEAKS), this.getParameterAsInt(PARAMETER_ADAPTION_TYPE), this.getParameterAsInt(PARAMETER_ATTRIBUTES_PER_PEAK), this.getParameterAsDouble(PARAMETER_EPSILON), this.getRandom());
            fourierGen.setStartGenerations(startSinus);
            fourierGen.setApplyInGeneration(0);
            popOps.add(fourierGen);
        }
        return popOps;
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        types.add(new ParameterTypeInt(PARAMETER_NUMBER_ORIGINAL, "The maximum of original attributes added in each generation.", 0, Integer.MAX_VALUE, 2));
        types.add(new ParameterTypeInt(PARAMETER_NUMBER_CONSTRUCTED, "The maximum number of attributes constructed in each generation.", 0, Integer.MAX_VALUE, 2));
        types.add(new ParameterTypeString("unused_functions", "Space separated list of functions which are not allowed in arguments for attribute construction."));
        types.add(new ParameterTypeInt(PARAMETER_START_SINUS_BOOST, "Uses a fourier generation in this first generations", 0, Integer.MAX_VALUE, 0));
        types.add(new ParameterTypeInt(PARAMETER_SEARCH_FOURIER_PEAKS, "Use this number of highest frequency peaks for sinus generation.", 0, Integer.MAX_VALUE, 0));
        types.add(new ParameterTypeInt(PARAMETER_ATTRIBUTES_PER_PEAK, "Use this number of additional peaks for each found peak.", 1, Integer.MAX_VALUE, 1));
        types.add(new ParameterTypeDouble(PARAMETER_EPSILON, "Use this range for additional peaks for each found peak.", 0.0, Double.POSITIVE_INFINITY, 0.1));
        types.add(new ParameterTypeCategory(PARAMETER_ADAPTION_TYPE, "Use this adaption type for additional peaks.", SinusFactory.ADAPTION_TYPES, 2));
        return types;
    }
}

