/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.features.construction;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.table.AttributeFactory;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.features.construction.AbstractFeatureConstruction;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeDouble;
import com.rapidminer.parameter.ParameterTypeString;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GaussFeatureConstructionOperator
extends AbstractFeatureConstruction {
    public static final String PARAMETER_ATTRIBUTE_NAME = "attribute_name";
    public static final String PARAMETER_MEAN = "mean";
    public static final String PARAMETER_SIGMA = "sigma";

    public GaussFeatureConstructionOperator(OperatorDescription description) {
        super(description);
    }

    @Override
    public ExampleSet apply(ExampleSet exampleSet) throws OperatorException {
        String attributeName = this.getParameterAsString(PARAMETER_ATTRIBUTE_NAME);
        double mean = this.getParameterAsDouble(PARAMETER_MEAN);
        double sigma = this.getParameterAsDouble(PARAMETER_SIGMA);
        LinkedList<Attribute> newAttributes = new LinkedList<Attribute>();
        for (Attribute attribute : exampleSet.getAttributes()) {
            if (!attribute.isNumerical() || !attribute.getName().matches(attributeName)) continue;
            newAttributes.add(this.createAttribute(exampleSet, attribute, mean, sigma));
        }
        for (Attribute attribute : newAttributes) {
            exampleSet.getAttributes().addRegular(attribute);
        }
        return exampleSet;
    }

    private Attribute createAttribute(ExampleSet exampleSet, Attribute base, double mean, double sigma) {
        Attribute newAttribute = AttributeFactory.createAttribute("gauss(" + base.getName() + ", " + mean + ", " + sigma + ")", 4);
        exampleSet.getExampleTable().addAttribute(newAttribute);
        for (Example example : exampleSet) {
            double value = example.getValue(base);
            double gaussValue = Math.exp(-1.0 * ((value - mean) * (value - mean)) / (sigma * sigma));
            example.setValue(newAttribute, gaussValue);
        }
        return newAttribute;
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        types.add(new ParameterTypeString(PARAMETER_ATTRIBUTE_NAME, "Indicates on which attribute(s) the gaussian construction should be applied (regular expression possible)", false));
        types.add(new ParameterTypeDouble(PARAMETER_MEAN, "The mean value for the gaussian function.", Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, 0.0));
        types.add(new ParameterTypeDouble(PARAMETER_SIGMA, "The sigma value for the gaussian function.", Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, 1.0));
        return types;
    }
}

