/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.preprocessing.filter;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.AttributeRole;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.table.AttributeFactory;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.preprocessing.AbstractDataProcessing;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeBoolean;
import com.rapidminer.parameter.ParameterTypeInt;
import com.rapidminer.parameter.ParameterTypeSingle;
import com.rapidminer.parameter.ParameterTypeString;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AttributeValueSubstring
extends AbstractDataProcessing {
    public static final String PARAMETER_ATTRIBUTES = "attributes";
    public static final String PARAMETER_APPLY_TO_SPECIAL_FEATURES = "apply_to_special_features";
    public static final String PARAMETER_FIRST = "first";
    public static final String PARAMETER_LAST = "last";

    public AttributeValueSubstring(OperatorDescription description) {
        super(description);
    }

    @Override
    public ExampleSet apply(ExampleSet exampleSet) throws OperatorException {
        String regex = this.getParameterAsString(PARAMETER_ATTRIBUTES);
        int firstIndex = this.getParameterAsInt(PARAMETER_FIRST);
        int lastIndex = this.getParameterAsInt(PARAMETER_LAST);
        Pattern pattern = null;
        try {
            pattern = Pattern.compile(regex);
        }
        catch (PatternSyntaxException e) {
            throw new UserError((Operator)this, 206, regex, e.getMessage());
        }
        Iterator<Attribute> i = exampleSet.getAttributes().iterator();
        if (this.getParameterAsBoolean(PARAMETER_APPLY_TO_SPECIAL_FEATURES)) {
            i = exampleSet.getAttributes().allAttributes();
        }
        LinkedList<Attribute> matchingAttributes = new LinkedList<Attribute>();
        while (i.hasNext()) {
            Attribute attribute = i.next();
            Matcher matcher = pattern.matcher(attribute.getName());
            if (matcher.matches()) {
                if (attribute.isNominal()) {
                    matchingAttributes.add(attribute);
                } else {
                    this.logWarning("Cannot create substring for non-nominal attribute '" + attribute.getName() + "', skipping...");
                }
            }
            this.checkForStop();
        }
        for (Attribute attribute : matchingAttributes) {
            Attribute newAttribute = this.createSubstringAttribute(exampleSet, attribute, firstIndex, lastIndex);
            AttributeRole role = exampleSet.getAttributes().getRole(attribute);
            exampleSet.getAttributes().remove(attribute);
            newAttribute.setName(attribute.getName());
            if (!role.isSpecial()) continue;
            String specialName = role.getSpecialName();
            exampleSet.getAttributes().setSpecialAttribute(newAttribute, specialName);
        }
        return exampleSet;
    }

    private Attribute createSubstringAttribute(ExampleSet exampleSet, Attribute originalAttribute, int firstIndex, int lastIndex) {
        Attribute newAttribute = AttributeFactory.createAttribute(1);
        exampleSet.getExampleTable().addAttribute(newAttribute);
        exampleSet.getAttributes().addRegular(newAttribute);
        for (Example example : exampleSet) {
            double value = example.getValue(originalAttribute);
            if (Double.isNaN(value)) {
                example.setValue(newAttribute, Double.NaN);
                continue;
            }
            String stringValue = originalAttribute.getMapping().mapIndex((int)value);
            int actualFirst = firstIndex - 1;
            int actualLast = lastIndex;
            if (lastIndex > stringValue.length()) {
                actualLast = stringValue.length();
            }
            if (lastIndex < firstIndex) {
                example.setValue(newAttribute, Double.NaN);
                continue;
            }
            String newValue = stringValue.substring(actualFirst, actualLast);
            if (newValue.length() == 0) {
                example.setValue(newAttribute, Double.NaN);
                continue;
            }
            example.setValue(newAttribute, newValue);
        }
        return newAttribute;
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        ParameterTypeSingle type = new ParameterTypeString(PARAMETER_ATTRIBUTES, "Substring creation of values will be applied to the attributes that match the given regular expression.", false);
        types.add(type);
        types.add(new ParameterTypeBoolean(PARAMETER_APPLY_TO_SPECIAL_FEATURES, "Filter also special attributes (label, id...)", false));
        type = new ParameterTypeInt(PARAMETER_FIRST, "The index of the first character of the substring which should be kept (counting starts with 1, 0: start with beginning of value).", 1, Integer.MAX_VALUE, 1);
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeInt(PARAMETER_LAST, "The index of the last character of the substring which should be kept (counting starts with 1, 0: end with end of value).", 1, Integer.MAX_VALUE, Integer.MAX_VALUE);
        type.setExpert(false);
        types.add(type);
        return types;
    }
}

