/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.preprocessing.series;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.AttributeRole;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.table.AttributeFactory;
import com.rapidminer.example.table.DoubleArrayDataRow;
import com.rapidminer.example.table.MemoryExampleTable;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.preprocessing.series.Series2WindowExamples;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeBoolean;
import com.rapidminer.parameter.ParameterTypeCategory;
import com.rapidminer.parameter.ParameterTypeInt;
import com.rapidminer.parameter.ParameterTypeString;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultivariateSeries2WindowExamples
extends Series2WindowExamples {
    public static final String PARAMETER_LABEL_ATTRIBUTE = "label_attribute";
    public static final String PARAMETER_LABEL_DIMENSION = "label_dimension";
    public static final String PARAMETER_ADD_INCOMPLETE_WINDOWS = "add_incomplete_windows";

    public MultivariateSeries2WindowExamples(OperatorDescription description) {
        super(description);
    }

    @Override
    public Attribute createLabel(ExampleSet exampleSet, int representation) throws OperatorException {
        if (this.isParameterSet(PARAMETER_LABEL_ATTRIBUTE) || this.isParameterSet(PARAMETER_LABEL_DIMENSION)) {
            int labelDimension = this.getLabelDimension(exampleSet);
            int a = 0;
            int valueType = -1;
            Iterator<Attribute> iterator = exampleSet.getAttributes().allAttributes();
            while (iterator.hasNext()) {
                Attribute currentAttribute = iterator.next();
                if (a == labelDimension) {
                    valueType = currentAttribute.getValueType();
                    break;
                }
                ++a;
            }
            if (valueType >= 0) {
                return AttributeFactory.createAttribute("label", valueType);
            }
            return null;
        }
        return null;
    }

    @Override
    public int[] getValueTypes(ExampleSet exampleSet, int representation, int windowWidth) {
        if (representation == 0) {
            int[] valueTypes = new int[windowWidth * exampleSet.getAttributes().size()];
            int counter = 0;
            for (Attribute attribute : exampleSet.getAttributes()) {
                int valueType = attribute.getValueType();
                int w = 0;
                while (w < windowWidth) {
                    valueTypes[counter++] = valueType;
                    ++w;
                }
            }
            return valueTypes;
        }
        int[] valueTypes = new int[windowWidth * exampleSet.size()];
        int valueType = -1;
        for (Attribute attribute : exampleSet.getAttributes()) {
            if (valueType >= 0) continue;
            valueType = attribute.getValueType();
            break;
        }
        int i = 0;
        while (i < valueTypes.length) {
            valueTypes[i] = valueType;
            ++i;
        }
        return valueTypes;
    }

    @Override
    public String getNameForAttribute(Attribute[] originalAttributeArray, int representation, int windowWidth, int horizon, int totalCounter) {
        if (representation == 0) {
            int attributeIndex = totalCounter / windowWidth;
            String baseName = originalAttributeArray[attributeIndex].getName();
            int windowIndex = totalCounter % windowWidth;
            return String.valueOf(baseName) + "-" + (windowWidth - windowIndex - 1);
        }
        return "Series_" + totalCounter;
    }

    @Override
    public void performChecks(ExampleSet exampleSet, int representation, int windowWidth, int stepSize, int horizon) throws OperatorException {
        if (this.isParameterSet(PARAMETER_LABEL_ATTRIBUTE) && this.isParameterSet(PARAMETER_LABEL_DIMENSION)) {
            throw new UserError((Operator)this, 209, PARAMETER_LABEL_ATTRIBUTE, PARAMETER_LABEL_DIMENSION);
        }
        if (representation == 0) {
            if (exampleSet.size() < windowWidth + horizon) {
                throw new UserError((Operator)this, 110, "window width + horizon = " + (windowWidth + horizon));
            }
        } else {
            if (exampleSet.getAttributes().getId() != null) {
                throw new UserError((Operator)this, 136, exampleSet.getAttributes().getId().getName());
            }
            if (exampleSet.getAttributes().size() < windowWidth + horizon) {
                throw new UserError((Operator)this, 125, exampleSet.getAttributes().size(), windowWidth + horizon);
            }
            int valueType = -1;
            for (Attribute attribute : exampleSet.getAttributes()) {
                if (valueType < 0) {
                    valueType = attribute.getValueType();
                    continue;
                }
                if (attribute.getValueType() == valueType) continue;
                throw new UserError(this, 126);
            }
        }
    }

    private int getLabelDimension(ExampleSet exampleSet) throws OperatorException {
        int labelDimension = -1;
        if (this.isParameterSet(PARAMETER_LABEL_DIMENSION)) {
            labelDimension = this.getParameterAsInt(PARAMETER_LABEL_DIMENSION);
        } else {
            String labelAttributeName = this.getParameterAsString(PARAMETER_LABEL_ATTRIBUTE);
            labelDimension = -1;
            int index = 0;
            Iterator<Attribute> iterator = exampleSet.getAttributes().allAttributes();
            while (iterator.hasNext()) {
                Attribute attribute = iterator.next();
                if (attribute.getName().equals(labelAttributeName)) {
                    labelDimension = index;
                    break;
                }
                ++index;
            }
        }
        return labelDimension;
    }

    @Override
    public void fillSeriesExampleTable(MemoryExampleTable table, ExampleSet exampleSet, Attribute idAttribute, int representation, int windowWidth, int stepSize, int horizon) throws OperatorException {
        int labelDimension = this.getLabelDimension(exampleSet);
        if (representation == 0) {
            int offset;
            int labelOffset = labelDimension == -1 ? 0 : 1;
            int idOffset = idAttribute == null ? 0 : 1;
            int w = offset = this.getParameterAsBoolean(PARAMETER_ADD_INCOMPLETE_WINDOWS) ? -windowWidth + 1 : 0;
            while (w < exampleSet.size() - windowWidth - horizon) {
                double[] data = new double[windowWidth * exampleSet.getAttributes().size() + labelOffset + idOffset];
                int a = 0;
                Iterator<AttributeRole> iterator = exampleSet.getAttributes().allAttributeRoles();
                while (iterator.hasNext()) {
                    int index;
                    AttributeRole currentRole = iterator.next();
                    Attribute currentAttribute = currentRole.getAttribute();
                    if (!currentRole.isSpecial()) {
                        int d = 0;
                        while (d < windowWidth) {
                            Attribute newAttribute;
                            int index2 = a * windowWidth + d;
                            data[index2] = w + d >= 0 ? ((newAttribute = table.getAttribute(index2)).isNominal() ? (double)newAttribute.getMapping().mapString(currentAttribute.getMapping().mapIndex((int)exampleSet.getExample(w + d).getValue(currentAttribute))) : exampleSet.getExample(w + d).getValue(currentAttribute)) : Double.NaN;
                            ++d;
                        }
                    }
                    if (idAttribute != null) {
                        index = data.length - 1;
                        Attribute newAttribute = table.getAttribute(index);
                        data[index] = newAttribute.isNominal() ? (double)newAttribute.getMapping().mapString(idAttribute.getMapping().mapIndex((int)exampleSet.getExample(w + windowWidth - 1).getValue(idAttribute))) : exampleSet.getExample(w + windowWidth - 1).getValue(idAttribute);
                    }
                    if (a == labelDimension) {
                        Attribute newAttribute;
                        index = data.length - 2;
                        if (idAttribute == null) {
                            index = data.length - 1;
                        }
                        data[index] = (newAttribute = table.getAttribute(index)).isNominal() ? (double)newAttribute.getMapping().mapString(currentAttribute.getMapping().mapIndex((int)exampleSet.getExample(w + windowWidth + horizon).getValue(currentAttribute))) : exampleSet.getExample(w + windowWidth + horizon).getValue(currentAttribute);
                    }
                    ++a;
                }
                table.addDataRow(new DoubleArrayDataRow(data));
                this.checkForStop();
                w += stepSize;
            }
        } else {
            int lastAttribute = exampleSet.getAttributes().size() - windowWidth - horizon;
            Attribute[] attributeArray = new Attribute[exampleSet.getAttributes().size()];
            int index = 0;
            for (Attribute attribute : exampleSet.getAttributes()) {
                attributeArray[index++] = attribute;
            }
            int offset = this.getParameterAsBoolean(PARAMETER_ADD_INCOMPLETE_WINDOWS) ? -windowWidth + 1 : 0;
            int labelOffset = labelDimension == -1 ? 0 : 1;
            int w = offset;
            while (w < lastAttribute) {
                double[] data = new double[windowWidth * exampleSet.size() + labelOffset];
                int counter = 0;
                for (Example example : exampleSet) {
                    int d = 0;
                    while (d < windowWidth) {
                        data[counter * windowWidth + d] = w + d >= 0 ? example.getValue(attributeArray[w + d]) : Double.NaN;
                        ++d;
                    }
                    if (counter == labelDimension) {
                        data[data.length - 1] = example.getValue(attributeArray[w + windowWidth + horizon]);
                    }
                    ++counter;
                }
                table.addDataRow(new DoubleArrayDataRow(data));
                this.checkForStop();
                w += stepSize;
            }
        }
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        for (ParameterType candidateType : types) {
            if (candidateType.getKey().equals("horizon")) {
                ((ParameterTypeInt)candidateType).setMinValue(0);
                ((ParameterTypeInt)candidateType).setDefaultValue(0);
                candidateType.setExpert(true);
            }
            if (!candidateType.getKey().equals("series_representation")) continue;
            ((ParameterTypeCategory)candidateType).setDefaultValue(0);
        }
        ParameterTypeString type = new ParameterTypeString(PARAMETER_LABEL_ATTRIBUTE, "The name of the attribute which should be used for creating the label values.", true);
        types.add(type);
        types.add(new ParameterTypeInt(PARAMETER_LABEL_DIMENSION, "The dimension which should be used for creating the label values (counting starts with 0).", 0, Integer.MAX_VALUE, true));
        types.add(new ParameterTypeBoolean(PARAMETER_ADD_INCOMPLETE_WINDOWS, "Create windows for all examples, which causes missings in the first windows.", false));
        return types;
    }
}

