/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.test;

import com.rapidminer.tools.Tools;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.util.Random;

public class ExampleGenerator {
    private static final String[][] NOMINAL_VALUES = new String[][]{{"hund", "katze", "maus", "elefant"}, {"flasche", "strase", "batzen"}, {"ming", "vase", "line"}};

    public static void main(String[] argv) {
        try {
            String filestem = argv[0];
            int type = Integer.parseInt(argv[1]);
            int numOfExamples = Integer.parseInt(argv[2]);
            int numOfRealAttributes = Integer.parseInt(argv[3]);
            int numOfNominalAttributes = Integer.parseInt(argv[4]);
            double error = Double.parseDouble(argv[5]);
            boolean labelled = argv.length <= 6 || !argv[6].equals("nolabel");
            int numOfAttributes = numOfRealAttributes + numOfNominalAttributes;
            boolean nominalLabel = false;
            PrintStream eout = new PrintStream(new FileOutputStream(new File(String.valueOf(filestem) + ".dat")));
            eout.println("# Generated by com.rapidminer.test.ExampleGenerator");
            eout.println("#   function type: " + type);
            eout.println("#   error:         " + error);
            eout.println("#   #examples:     " + numOfExamples);
            Random r = new Random(0L);
            int i = 0;
            while (i < numOfExamples) {
                int index;
                double[] att = new double[numOfAttributes + 1];
                int j = 0;
                while (j < numOfRealAttributes) {
                    att[j] = r.nextDouble() * 20.0 - 10.0;
                    ++j;
                }
                j = 0;
                while (j < numOfNominalAttributes) {
                    index = j + numOfRealAttributes;
                    att[index] = r.nextInt(NOMINAL_VALUES[index % NOMINAL_VALUES.length].length);
                    ++j;
                }
                j = 0;
                while (j < numOfRealAttributes) {
                    att[j] = r.nextDouble() * 20.0 - 10.0;
                    ++j;
                }
                j = 0;
                while (j < numOfNominalAttributes) {
                    index = j + numOfRealAttributes;
                    att[index] = r.nextInt(NOMINAL_VALUES[index % NOMINAL_VALUES.length].length);
                    ++j;
                }
                double f = 1.0 + r.nextDouble() * 2.0 * error - error;
                switch (type) {
                    case 1: {
                        att[numOfAttributes] = (att[0] + att[1] + att[2]) * f;
                        break;
                    }
                    case 2: {
                        att[numOfAttributes] = att[0] + att[1] - 2.0 * att[2] > 0.0 ? 1 : 0;
                        break;
                    }
                    case 3: {
                        att[numOfAttributes] = r.nextDouble();
                        break;
                    }
                    case 4: {
                        att[numOfAttributes] = (att[0] * att[1] * att[2] + att[0] * att[1] + att[1] * att[1]) * f;
                        break;
                    }
                    case 5: {
                        att[numOfAttributes] = att[numOfAttributes - 3] == 1.0 || att[numOfAttributes - 2] == 1.0 && att[numOfAttributes - 1] == 2.0 ? 0.0 : 1.0;
                        nominalLabel = true;
                        break;
                    }
                    case 6: {
                        att[numOfAttributes] = att[0] + att[1];
                        att[2] = Math.random() < 0.25 ? Double.NaN : att[2];
                        break;
                    }
                    case 7: {
                        att[numOfAttributes] = 2.0 * att[0] - att[1] - att[2] > 0.0 ? 0.0 : 1.0;
                        nominalLabel = true;
                        break;
                    }
                    case 8: {
                        att[numOfAttributes] = Math.sin(att[0] * att[1]) + Math.sin(att[0] + att[1]) > 0.0 ? 0.0 : 1.0;
                        nominalLabel = true;
                        break;
                    }
                    case 9: {
                        att[numOfAttributes] = Math.sin(att[0] * att[1]) + Math.sin(att[0] + att[1]) + att[0] * att[1] + att[0] + att[1] > 0.0 ? 0.0 : 1.0;
                        nominalLabel = true;
                        break;
                    }
                    case 10: {
                        att[numOfAttributes] = Math.sin(att[0] * att[1]) + Math.sin(att[0] + att[1]) * f;
                        break;
                    }
                    case 11: {
                        att[numOfAttributes] = 50.0 * Math.sin(att[0] * att[1]) + 20.0 * Math.sin(att[0] + att[1]) + 5.0 * att[0] * att[1] + att[0] + 3.0 * att[1] * f;
                        break;
                    }
                    case 12: {
                        att[numOfAttributes] = 10.0 * Math.sin(3.0 * att[0]) + 12.0 * Math.sin(7.0 * att[0]) + 11.0 * Math.sin(5.0 * att[1]) + 9.0 * Math.sin(10.0 * att[1]) + 10.0 * Math.sin(8.0 * (att[0] + att[1]));
                        break;
                    }
                    case 13: {
                        att[numOfAttributes] = Math.sin(10.0 * att[0]) + Math.sin(15.0 * att[1]);
                        break;
                    }
                    case 14: {
                        att[numOfAttributes] = !(Math.sin(att[0]) > 0.0) ? 1 : 0;
                        nominalLabel = true;
                    }
                }
                int j2 = 0;
                while (j2 < numOfAttributes) {
                    if (j2 < numOfRealAttributes) {
                        eout.print(String.valueOf(att[j2]) + "\t");
                    } else {
                        eout.print(String.valueOf(NOMINAL_VALUES[j2 % NOMINAL_VALUES.length][(int)att[j2]]) + "\t");
                    }
                    ++j2;
                }
                if (labelled) {
                    if (nominalLabel) {
                        eout.print(att[numOfAttributes] == 0.0 ? "positive" : "negative");
                    } else {
                        eout.print(att[numOfAttributes]);
                    }
                }
                eout.println();
                ++i;
            }
            eout.close();
            PrintStream aout = new PrintStream(new FileOutputStream(new File(String.valueOf(filestem) + ".att.xml")));
            aout.println("<!--");
            aout.println(" Generated by com.rapidminer.test.ExampleGenerator");
            aout.println("   function type: " + type);
            aout.println("   error:         " + error);
            aout.println("-->" + Tools.getLineSeparator());
            aout.println("<attributeset default_source=\"" + filestem + ".dat\">");
            int i2 = 0;
            while (i2 <= numOfAttributes) {
                aout.println(i2 < numOfAttributes ? "  <attribute" : "  <label");
                aout.println("    name         = \"" + (i2 < numOfAttributes ? "att" + (i2 + 1) : "label") + "\"");
                String sourcecol = String.valueOf(i2 + 1);
                if (i2 == numOfAttributes && !labelled) {
                    sourcecol = "none";
                }
                aout.println("    sourcecol    = \"" + sourcecol + "\"");
                aout.println("    valuetype    = \"" + (i2 >= numOfRealAttributes && (i2 != numOfAttributes || nominalLabel) ? "nominal\"" : "real\""));
                if (i2 >= numOfRealAttributes && (i2 != numOfAttributes || nominalLabel)) {
                    aout.print("    classes      = \"");
                    if (i2 == numOfAttributes) {
                        aout.print("negative positive");
                    } else {
                        int c = 0;
                        while (c < NOMINAL_VALUES[i2 % NOMINAL_VALUES.length].length) {
                            aout.print(String.valueOf(c > 0 ? " " : "") + NOMINAL_VALUES[i2 % NOMINAL_VALUES.length][c]);
                            ++c;
                        }
                    }
                    aout.println("\"");
                }
                aout.println("    blocktype    = \"single_value\"");
                aout.println("    unit         = \"\"");
                aout.println("  />");
                ++i2;
            }
            aout.println("</attributeset>");
            aout.close();
            PrintStream xout = new PrintStream(new FileOutputStream(new File("xp." + filestem + ".xml")));
            xout.println("<!--");
            xout.println(" Generated by com.rapidminer.test.ExampleGenerator");
            xout.println("   function type: " + type);
            xout.println("   error:         " + error);
            xout.println("-->");
            xout.println();
            xout.println("<operator name=\"Globalator\" class=\"OperatorChain\">");
            xout.println("  <parameter key=\"logfile\"         value=\"Log_" + filestem + ".txt\"/>");
            xout.println("  <parameter key=\"logverbosity\"    value=\"0\"/>");
            xout.println("  <parameter key=\"resultfile\"      value=\"Result_" + filestem + ".txt\"/>");
            xout.println("  <parameter key=\"temp_dir\"        value=\"./tmp\"/>");
            xout.println();
            xout.println("  <operator name=\"Initiator\" class=\"ExampleSource\">");
            xout.println("    <parameter key=\"attributes\"       value=\"./" + filestem + ".att.xml\"/>");
            xout.println("  </operator>");
            xout.println();
            xout.println("  <!-- insert process definition here -->");
            xout.println();
            xout.println("</operator>");
            xout.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            System.err.println("Usage: ExampleGenerator filestem functiontype #examples #realattributes #nominalattributes error [nolabel]");
        }
    }
}

