/*
 * Decompiled with CFR 0.152.
 */
package be.ac.ulg.montefiore.run.jahmm;

import be.ac.ulg.montefiore.run.jahmm.ForwardBackwardCalculator;
import be.ac.ulg.montefiore.run.jahmm.ForwardBackwardScaledCalculator;
import be.ac.ulg.montefiore.run.jahmm.Observation;
import be.ac.ulg.montefiore.run.jahmm.Opdf;
import be.ac.ulg.montefiore.run.jahmm.OpdfFactory;
import be.ac.ulg.montefiore.run.jahmm.ViterbiCalculator;
import java.io.Serializable;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Hmm<O extends Observation>
implements Serializable,
Cloneable {
    private double[] pi;
    private double[][] a;
    private ArrayList<Opdf<O>> opdfs;
    private static final long serialVersionUID = 2L;

    public Hmm(int nbStates, OpdfFactory<? extends Opdf<O>> opdfFactory) {
        if (nbStates <= 0) {
            throw new IllegalArgumentException("Number of states must be strictly positive");
        }
        this.pi = new double[nbStates];
        this.a = new double[nbStates][nbStates];
        this.opdfs = new ArrayList(nbStates);
        int i = 0;
        while (i < nbStates) {
            this.pi[i] = 1.0 / (double)nbStates;
            this.opdfs.add(opdfFactory.factor());
            int j = 0;
            while (j < nbStates) {
                this.a[i][j] = 1.0 / (double)nbStates;
                ++j;
            }
            ++i;
        }
    }

    public Hmm(double[] pi, double[][] a, List<? extends Opdf<O>> opdfs) {
        if (a.length == 0 || pi.length != a.length || opdfs.size() != a.length) {
            throw new IllegalArgumentException("Wrong parameter");
        }
        this.pi = (double[])pi.clone();
        this.a = new double[a.length][];
        int i = 0;
        while (i < a.length) {
            if (a[i].length != a.length) {
                throw new IllegalArgumentException("'A' is not a squarematrix");
            }
            this.a[i] = (double[])a[i].clone();
            ++i;
        }
        this.opdfs = new ArrayList<Opdf<O>>(opdfs);
    }

    protected Hmm(int nbStates) {
        if (nbStates <= 0) {
            throw new IllegalArgumentException("Number of states must be positive");
        }
        this.pi = new double[nbStates];
        this.a = new double[nbStates][nbStates];
        this.opdfs = new ArrayList(nbStates);
        int i = 0;
        while (i < nbStates) {
            this.opdfs.add(null);
            ++i;
        }
    }

    public int nbStates() {
        return this.pi.length;
    }

    public double getPi(int stateNb) {
        return this.pi[stateNb];
    }

    public void setPi(int stateNb, double value) {
        this.pi[stateNb] = value;
    }

    public Opdf<O> getOpdf(int stateNb) {
        return this.opdfs.get(stateNb);
    }

    public void setOpdf(int stateNb, Opdf<O> opdf) {
        this.opdfs.set(stateNb, opdf);
    }

    public double getAij(int i, int j) {
        return this.a[i][j];
    }

    public void setAij(int i, int j, double value) {
        this.a[i][j] = value;
    }

    public int[] mostLikelyStateSequence(List<? extends O> oseq) {
        return new ViterbiCalculator(oseq, this).stateSequence();
    }

    public double probability(List<? extends O> oseq) {
        return new ForwardBackwardCalculator(oseq, this).probability();
    }

    public double lnProbability(List<? extends O> oseq) {
        return new ForwardBackwardScaledCalculator(oseq, this).lnProbability();
    }

    public double probability(List<? extends O> oseq, int[] sseq) {
        if (oseq.size() != sseq.length || oseq.isEmpty()) {
            throw new IllegalArgumentException();
        }
        double probability = this.getPi(sseq[0]);
        Iterator<O> oseqIterator = oseq.iterator();
        int i = 0;
        while (i < sseq.length - 1) {
            probability *= this.getOpdf(sseq[i]).probability((Observation)oseqIterator.next()) * this.getAij(sseq[i], sseq[i + 1]);
            ++i;
        }
        return probability * this.getOpdf(sseq[sseq.length - 1]).probability((Observation)oseq.get(sseq.length - 1));
    }

    public String toString(NumberFormat nf) {
        String s = "HMM with " + this.nbStates() + " state(s)\n";
        int i = 0;
        while (i < this.nbStates()) {
            s = String.valueOf(s) + "\nState " + i + "\n";
            s = String.valueOf(s) + "  Pi: " + this.getPi(i) + "\n";
            s = String.valueOf(s) + "  Aij:";
            int j = 0;
            while (j < this.nbStates()) {
                s = String.valueOf(s) + " " + nf.format(this.getAij(i, j));
                ++j;
            }
            s = String.valueOf(s) + "\n";
            s = String.valueOf(s) + "  Opdf: " + this.getOpdf(i).toString(nf) + "\n";
            ++i;
        }
        return s;
    }

    public String toString() {
        return this.toString(NumberFormat.getInstance());
    }

    public Hmm<O> clone() throws CloneNotSupportedException {
        Hmm<O> hmm = new Hmm<O>(this.nbStates());
        hmm.pi = (double[])this.pi.clone();
        hmm.a = (double[][])this.a.clone();
        int i = 0;
        while (i < this.a.length) {
            hmm.a[i] = (double[])this.a[i].clone();
            ++i;
        }
        i = 0;
        while (i < hmm.opdfs.size()) {
            hmm.opdfs.set(i, this.opdfs.get(i).clone());
            ++i;
        }
        return hmm;
    }
}

