/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.extraction.util;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.table.AttributeFactory;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.extraction.AttributeQueryMap;
import com.rapidminer.operator.extraction.ExtractionException;
import com.rapidminer.operator.extraction.RegexExtractor;
import com.rapidminer.operator.extraction.TextExtractor;
import com.rapidminer.operator.extraction.XPathExtractor;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeList;
import com.rapidminer.parameter.ParameterTypeString;
import com.rapidminer.parameter.Parameters;
import com.rapidminer.parameter.UndefinedParameterError;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.PatternSyntaxException;
import org.jaxen.JaxenException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FeatureExtractionUtil {
    public static final String PARAMETER_ATTRIBUTES = "attributes";
    public static final String PARAMETER_NAMESPACES = "namespaces";

    public static ParameterType createQueryParameter() {
        return new ParameterTypeList(PARAMETER_ATTRIBUTES, "Specifies a list of attribute names and extraction queries. These queries can be XPath or a regular expression. If a regular expression is used, the query must have the following form: '<regex-expression> <replacement-pattern>', where the <replacement_pattern> states how a match is replaced to generate the final information. '$1' would yield the first matching group as result. A number sign in front of an attribute name marks the attribute as numeric. In these cases, the operator uses different heuristicts to parse a number from the extracted string. An ! in front of an attribute name marks it as binary. For both XPath and regex, only the first match is used.", (ParameterType)new ParameterTypeString("query_expr", "query expression: either ?<xpath> where <xpath> is an XPath expression or <regex> <target> where <regex> is a regular expression and target is a string referencing the match, e.g. \"[0-9]+\\sEuro $1\"", false));
    }

    public static ParameterType createNamespaceParameter() {
        return new ParameterTypeList(PARAMETER_NAMESPACES, "Specifies pairs of identifier and namespace for use in XPath queries. The namespace for (x)html is bound automatically to the identifier h.", (ParameterType)new ParameterTypeString("name_space", "An id and the namespace to which it should be bound.", false));
    }

    public static Map<String, String> getNamespaceMapping(Parameters params) {
        List nameSpaceParameterList = null;
        try {
            nameSpaceParameterList = Parameters.transformString2List((String)params.getParameter(PARAMETER_NAMESPACES));
        }
        catch (UndefinedParameterError undefinedParameterError) {
            // empty catch block
        }
        if (nameSpaceParameterList != null) {
            HashMap<String, String> result = new HashMap<String, String>();
            for (String[] entry : nameSpaceParameterList) {
                result.put(entry[0], entry[1]);
            }
            return result;
        }
        return new HashMap<String, String>();
    }

    public static AttributeQueryMap getAttributeQueryMap(Parameters params) throws ExtractionException {
        Map<String, String> namespaceMap = FeatureExtractionUtil.getNamespaceMapping(params);
        List requests = null;
        try {
            requests = Parameters.transformString2List((String)params.getParameter(PARAMETER_ATTRIBUTES));
        }
        catch (UndefinedParameterError undefinedParameterError) {
            // empty catch block
        }
        if (requests != null) {
            AttributeQueryMap result = new AttributeQueryMap();
            for (String[] entry : requests) {
                Attribute newAttribute = null;
                String attributeStr = entry[0];
                if (attributeStr.charAt(0) == '#') {
                    newAttribute = AttributeFactory.createAttribute((String)attributeStr.substring(1), (int)4);
                } else if (attributeStr.charAt(0) == '!') {
                    newAttribute = AttributeFactory.createAttribute((String)attributeStr.substring(1), (int)6);
                    newAttribute.getMapping().mapString("false");
                    newAttribute.getMapping().mapString("true");
                } else {
                    newAttribute = AttributeFactory.createAttribute((String)attributeStr, (int)1);
                }
                TextExtractor extractor = FeatureExtractionUtil.getExtractor(entry[1], namespaceMap);
                if (extractor == null) continue;
                result.addQuery(newAttribute, extractor);
            }
            return result;
        }
        return new AttributeQueryMap();
    }

    public static TextExtractor getExtractor(String query, Map<String, String> namespaceMap) throws ExtractionException {
        if (query.charAt(0) == '/') {
            XPathExtractor xpe = null;
            try {
                xpe = new XPathExtractor(query, namespaceMap);
            }
            catch (JaxenException e) {
                throw new ExtractionException("", (Exception)((Object)e), new UserError(null, 211, new Object[]{query, e}));
            }
            return xpe;
        }
        RegexExtractor extr = null;
        try {
            extr = new RegexExtractor(query);
        }
        catch (PatternSyntaxException e) {
            throw new ExtractionException("", e, new UserError(null, 206, new Object[]{query, e}));
        }
        return extr;
    }
}

