/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.operatortree.actions;

import com.rapidminer.gui.ConditionalAction;
import com.rapidminer.gui.RapidMinerGUI;
import com.rapidminer.gui.operatortree.OperatorTree;
import com.rapidminer.gui.templates.BuildingBlock;
import com.rapidminer.gui.templates.SaveAsBuildingBlockDialog;
import com.rapidminer.gui.tools.IconSize;
import com.rapidminer.gui.tools.SwingTools;
import com.rapidminer.operator.Operator;
import com.rapidminer.tools.ParameterService;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import javax.swing.Icon;

public class SaveBuildingBlockAction
extends ConditionalAction {
    private static final long serialVersionUID = 2238740826770976483L;
    private static final String ICON_NAME = "box_add.png";
    private static final Icon[] ICONS = new Icon[IconSize.values().length];
    private OperatorTree operatorTree;

    static {
        int counter = 0;
        IconSize[] iconSizeArray = IconSize.values();
        int n = iconSizeArray.length;
        int n2 = 0;
        while (n2 < n) {
            IconSize size = iconSizeArray[n2];
            SaveBuildingBlockAction.ICONS[counter++] = SwingTools.createIcon(String.valueOf(size.getSize()) + "/" + ICON_NAME);
            ++n2;
        }
    }

    public SaveBuildingBlockAction(OperatorTree operatorTree, IconSize size) {
        super("Save as Building Block...", ICONS[size.ordinal()]);
        this.putValue("ShortDescription", "Save the selected operator as a new building block");
        this.putValue("MnemonicKey", 83);
        this.setCondition(0, 1);
        this.setCondition(2, -1);
        this.operatorTree = operatorTree;
    }

    public void actionPerformed(ActionEvent e) {
        Operator selectedOperator = this.operatorTree.getSelectedOperator();
        if (selectedOperator != null) {
            SaveAsBuildingBlockDialog dialog = new SaveAsBuildingBlockDialog(RapidMinerGUI.getMainFrame(), selectedOperator);
            dialog.setVisible(true);
            if (dialog.isOk()) {
                BuildingBlock buildingBlock = dialog.getBuildingBlock(selectedOperator);
                String name = buildingBlock.getName();
                try {
                    File buildingBlockFile = ParameterService.getUserConfigFile(String.valueOf(name) + ".buildingblock");
                    buildingBlock.save(buildingBlockFile);
                }
                catch (IOException ioe) {
                    SwingTools.showSimpleErrorMessage("Cannot write building block file:", ioe);
                }
            }
        }
    }
}

