/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.templates;

import com.rapidminer.tools.LogService;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BuildingBlock
implements Comparable<BuildingBlock> {
    private String name = "unnamed";
    private String description = "none";
    private String xmlDescription;
    private File buildingBlockFile;
    private String iconPath;

    public BuildingBlock(File file) throws InstantiationException {
        BufferedReader in = null;
        try {
            try {
                in = new BufferedReader(new FileReader(file));
                this.init(in);
                this.buildingBlockFile = file;
            }
            catch (IOException e) {
                LogService.getGlobal().logError("Cannot read building block file: " + e.getMessage());
                throw new InstantiationException("Cannot instantiate building block: " + e.getMessage());
            }
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    LogService.getGlobal().logError("Cannot close stream to building block file: " + e.getMessage());
                }
            }
        }
    }

    public BuildingBlock(BufferedReader in) throws IOException {
        this.init(in);
    }

    public BuildingBlock(String name, String description, String iconPath, String xmlDescription) {
        this.name = name;
        this.description = description;
        this.iconPath = iconPath;
        this.xmlDescription = xmlDescription;
    }

    private void init(BufferedReader in) throws IOException {
        this.name = in.readLine();
        this.description = in.readLine();
        this.iconPath = in.readLine();
        String line = null;
        StringBuffer result = new StringBuffer();
        while ((line = in.readLine()) != null) {
            result.append(line);
        }
        this.xmlDescription = result.toString();
    }

    public File getFile() {
        return this.buildingBlockFile;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public String getIconPath() {
        return this.iconPath;
    }

    public String getXML() {
        return this.xmlDescription;
    }

    public void save(File file) throws IOException {
        PrintWriter out = null;
        try {
            out = new PrintWriter(new FileWriter(file));
            out.println(this.name);
            out.println(this.description);
            out.println(this.iconPath);
            out.println(this.xmlDescription);
        }
        finally {
            if (out != null) {
                out.close();
            }
        }
    }

    public String toString() {
        return this.name;
    }

    @Override
    public int compareTo(BuildingBlock buildingBlock) {
        return this.name.compareTo(buildingBlock.name);
    }

    public boolean equals(Object o) {
        if (!(o instanceof BuildingBlock)) {
            return false;
        }
        return this.name.equals(((BuildingBlock)o).name);
    }

    public int hashCode() {
        return this.name.hashCode();
    }
}

