/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.tools;

import com.rapidminer.gui.tools.CellColorProviderYellow;
import com.rapidminer.gui.tools.ExtendedJTable;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;

public class ExtendedFixedColumnJTable
extends JScrollPane {
    private static final long serialVersionUID = -5141975629639275878L;
    private ExtendedJTable mainDataTable;

    private ExtendedFixedColumnJTable(ExtendedJTable mainDataTable, JViewport viewport, JTableHeader header) {
        super(mainDataTable);
        this.mainDataTable = mainDataTable;
        this.setRowHeader(viewport);
        this.setCorner("UPPER_LEFT_CORNER", header);
        mainDataTable.setShowPopupMenu(false);
    }

    public static ExtendedFixedColumnJTable createFixedColumnTable(TableModel model) {
        int max = 0;
        int r = 0;
        while (r < model.getRowCount()) {
            String valueString = model.getValueAt(r, 0).toString();
            max = Math.max(valueString.length() * 8, max);
            ++r;
        }
        final int preferredWidth = Math.min(max, 250);
        DefaultTableColumnModel cm = new DefaultTableColumnModel(){
            private static final long serialVersionUID = -4882307040329823339L;
            private boolean first = true;

            public void addColumn(TableColumn tc) {
                if (this.first) {
                    this.first = false;
                } else {
                    super.addColumn(tc);
                }
            }
        };
        DefaultTableColumnModel rowHeaderModel = new DefaultTableColumnModel(){
            private static final long serialVersionUID = -4852540063984136543L;
            private boolean first = true;

            public void addColumn(TableColumn tc) {
                if (this.first) {
                    super.addColumn(tc);
                    tc.setPreferredWidth(preferredWidth);
                    this.first = false;
                }
            }
        };
        ExtendedJTable mainDataTable = new ExtendedJTable(model, false, true, false, true, false);
        mainDataTable.setColumnModel(cm);
        ExtendedJTable headerColumn = new ExtendedJTable(model, false, true, false, true, false);
        headerColumn.setCellColorProvider(new CellColorProviderYellow());
        headerColumn.setColumnModel(rowHeaderModel);
        mainDataTable.createDefaultColumnsFromModel();
        headerColumn.createDefaultColumnsFromModel();
        headerColumn.getTableHeader().setReorderingAllowed(false);
        headerColumn.getTableHeader().setResizingAllowed(false);
        mainDataTable.getSelectionModel().setSelectionMode(0);
        mainDataTable.setSelectionModel(headerColumn.getSelectionModel());
        headerColumn.setPreferredScrollableViewportSize(headerColumn.getPreferredSize());
        JViewport viewport = new JViewport();
        viewport.setView(headerColumn);
        viewport.setPreferredSize(headerColumn.getPreferredSize());
        return new ExtendedFixedColumnJTable(mainDataTable, viewport, headerColumn.getTableHeader());
    }

    public ExtendedJTable getMainDataTable() {
        return this.mainDataTable;
    }
}

