/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.clustering;

import com.rapidminer.tools.Tools;
import java.util.Collection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Centroid {
    private double[] centroid;
    private double[] centroidSum;
    private int numberOfAssigned = 0;

    public Centroid(int numberOfDimensions) {
        this.centroid = new double[numberOfDimensions];
        this.centroidSum = new double[numberOfDimensions];
    }

    public double[] getCentroid() {
        return this.centroid;
    }

    public void setCentroid(double[] coordinates) {
        this.centroid = coordinates;
    }

    public void assignExample(double[] exampleValues) {
        ++this.numberOfAssigned;
        int i = 0;
        while (i < exampleValues.length) {
            int n = i;
            this.centroidSum[n] = this.centroidSum[n] + exampleValues[i];
            ++i;
        }
    }

    public boolean finishAssign() {
        double[] newCentroid = new double[this.centroid.length];
        boolean stable = true;
        int i = 0;
        while (i < this.centroid.length) {
            newCentroid[i] = this.centroidSum[i] / (double)this.numberOfAssigned;
            stable &= Double.compare(newCentroid[i], this.centroid[i]) == 0;
            ++i;
        }
        this.centroid = newCentroid;
        this.centroidSum = new double[this.centroidSum.length];
        this.numberOfAssigned = 0;
        return stable;
    }

    public String toString(Collection<String> dimensionNames) {
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        for (String dimName : dimensionNames) {
            buffer.append(String.valueOf(dimName) + ":\t");
            buffer.append(String.valueOf(Tools.formatNumber(this.centroid[i])) + Tools.getLineSeparator());
            if (++i > 100) break;
        }
        return buffer.toString();
    }
}

