/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.clustering;

import com.rapidminer.operator.clustering.ClusterModel;
import com.rapidminer.tools.Tools;
import java.util.HashMap;
import java.util.Map;

public class FlatFuzzyClusterModel
extends ClusterModel {
    private static final long serialVersionUID = -1408826564261080217L;
    private final Map<Integer, Double> clusterStandardDeviations = new HashMap<Integer, Double>();
    private final Map<Integer, Double> clusterProbabilities = new HashMap<Integer, Double>();
    private final Map<Integer, double[]> clusterMeans = new HashMap<Integer, double[]>();
    private final Map<Integer, double[][]> clusterCovarianceMatrix = new HashMap<Integer, double[][]>();
    private double[][] exampleInClusterProbability;

    public FlatFuzzyClusterModel(int k) {
        super(k);
    }

    public double getExampleInClusterProbability(int example, int cluster) {
        return this.exampleInClusterProbability[example][cluster];
    }

    public void setExampleInClusterProbability(double[][] exampleInClusterProbability) {
        this.exampleInClusterProbability = new double[exampleInClusterProbability.length][exampleInClusterProbability[0].length];
        int i = 0;
        while (i < exampleInClusterProbability.length) {
            int j = 0;
            while (j < exampleInClusterProbability[i].length) {
                this.exampleInClusterProbability[i][j] = exampleInClusterProbability[i][j];
                ++j;
            }
            ++i;
        }
    }

    public double[] getClusterMean(int cluster) {
        return this.clusterMeans.get(cluster);
    }

    public void setClusterMean(int cluster, double[] value) {
        this.clusterMeans.put(cluster, value);
    }

    public double getClusterProbability(int cluster) {
        return this.clusterProbabilities.get(cluster);
    }

    public void setClusterProbability(int cluster, double value) {
        this.clusterProbabilities.put(cluster, value);
    }

    public double getClusterStandardDeviation(int cluster) {
        return this.clusterStandardDeviations.get(cluster);
    }

    public void setClusterStandardDeviation(int cluster, double value) {
        this.clusterStandardDeviations.put(cluster, value);
    }

    public void clearClusterStandardDeviations() {
        this.clusterStandardDeviations.clear();
    }

    public double[][] getClusterCovarianceMatrix(int cluster) {
        return this.clusterCovarianceMatrix.get(cluster);
    }

    public void setClusterCovarianceMatrix(int cluster, double[][] matrix) {
        this.clusterCovarianceMatrix.put(cluster, matrix);
    }

    public String toString() {
        int j;
        int i;
        StringBuffer result = new StringBuffer(String.valueOf(super.toString()) + Tools.getLineSeparator());
        result.append("------------------------------------------------------" + Tools.getLineSeparators(2));
        if (!this.clusterProbabilities.isEmpty()) {
            result.append("cluster probabilities:" + Tools.getLineSeparator());
            i = 0;
            while (i < this.clusterProbabilities.size()) {
                result.append("Cluster " + i + ": " + this.clusterProbabilities.get(i) + Tools.getLineSeparator());
                ++i;
            }
            result.append(Tools.getLineSeparator());
        }
        if (!this.clusterMeans.isEmpty()) {
            result.append("cluster means:" + Tools.getLineSeparator());
            i = 0;
            while (i < this.clusterMeans.size()) {
                result.append("Cluster " + i + ": ");
                j = 0;
                while (j < this.clusterMeans.get(i).length) {
                    result.append(this.clusterMeans.get(i)[j]);
                    if (j < this.clusterMeans.get(i).length - 1) {
                        result.append("; ");
                    }
                    ++j;
                }
                result.append(Tools.getLineSeparator());
                ++i;
            }
            result.append(Tools.getLineSeparator());
        }
        if (!this.clusterStandardDeviations.isEmpty()) {
            result.append("cluster standard deviations:" + Tools.getLineSeparator());
            i = 0;
            while (i < this.clusterStandardDeviations.size()) {
                result.append("Cluster " + i + ": " + this.clusterStandardDeviations.get(i) + Tools.getLineSeparator());
                ++i;
            }
            result.append(Tools.getLineSeparator());
        }
        if (!this.clusterCovarianceMatrix.isEmpty()) {
            result.append("cluster covariance matrices:" + Tools.getLineSeparator());
            i = 0;
            while (i < this.clusterCovarianceMatrix.size()) {
                result.append("Cluster " + i + ": " + Tools.getLineSeparator());
                j = 0;
                while (j < this.clusterMeans.get(i).length) {
                    int k = 0;
                    while (k < this.clusterCovarianceMatrix.get(i)[j].length) {
                        result.append(String.valueOf(this.clusterCovarianceMatrix.get(i)[j][k]) + "\t");
                        ++k;
                    }
                    result.append(Tools.getLineSeparator());
                    ++j;
                }
                ++i;
            }
            result.append(Tools.getLineSeparator());
        }
        return result.toString();
    }
}

