/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.meta;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.operator.IOContainer;
import com.rapidminer.operator.IOObject;
import com.rapidminer.operator.OperatorChain;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.ValueDouble;
import com.rapidminer.operator.ValueString;
import com.rapidminer.operator.condition.InnerOperatorCondition;
import com.rapidminer.operator.condition.LastInnerOperatorCondition;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeBoolean;
import com.rapidminer.parameter.ParameterTypeCategory;
import com.rapidminer.parameter.ParameterTypeString;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FeatureIterator
extends OperatorChain {
    public static final String PARAMETER_FILTER = "filter";
    public static final String PARAMETER_TYPE_FILTER = "type_filter";
    public static final String PARAMETER_WORK_ON_SPECIAL = "work_on_special";
    public static final String PARAMETER_INVERT_SELECTION = "invert_selection";
    public static final String PARAMETER_ITERATION_MACRO = "iteration_macro";
    public static final String[] TYPE_FILTERS = new String[]{"none", "nominal", "numerical"};
    public static final int TYPE_FILTER_NONE = 0;
    public static final int TYPE_FILTER_NOMINAL = 1;
    public static final int TYPE_FILTER_NUMERICAL = 2;
    public static final String DEFAULT_ITERATION_MACRO_NAME = "loop_feature";
    public static final String PARAMETER_WORK_ON_INPUT = "work_on_input";
    private int iteration;
    private String currentName = null;

    public FeatureIterator(OperatorDescription description) {
        super(description);
        this.addValue(new ValueDouble("iteration", "The number of the current iteration / loop."){

            public double getDoubleValue() {
                return FeatureIterator.this.iteration;
            }
        });
        this.addValue(new ValueString("feature_name", "The number of the current feature."){

            public String getStringValue() {
                return FeatureIterator.this.currentName;
            }
        });
    }

    @Override
    public IOObject[] apply() throws OperatorException {
        ExampleSet exampleSet = this.getInput(ExampleSet.class);
        String iterationMacroName = this.getParameterAsString(PARAMETER_ITERATION_MACRO);
        String filterRegExp = this.getParameterAsString(PARAMETER_FILTER);
        Pattern pattern = null;
        if (filterRegExp != null && filterRegExp.length() > 0) {
            pattern = Pattern.compile(filterRegExp);
        }
        int typeFilter = this.getParameterAsInt(PARAMETER_TYPE_FILTER);
        boolean invertSelection = this.getParameterAsBoolean(PARAMETER_INVERT_SELECTION);
        this.iteration = 0;
        LinkedList<Attribute> attributes = new LinkedList<Attribute>();
        if (this.getParameterAsBoolean(PARAMETER_WORK_ON_SPECIAL)) {
            Iterator<Attribute> a = exampleSet.getAttributes().allAttributes();
            while (a.hasNext()) {
                Attribute attribute = a.next();
                if (!this.acceptPattern(attribute, pattern, invertSelection) || !this.acceptType(attribute, typeFilter, invertSelection)) continue;
                attributes.add(attribute);
            }
        } else {
            for (Attribute attribute : exampleSet.getAttributes()) {
                if (!this.acceptPattern(attribute, pattern, invertSelection) || !this.acceptType(attribute, typeFilter, invertSelection)) continue;
                attributes.add(attribute);
            }
        }
        for (Attribute attribute : attributes) {
            String name = attribute.getName();
            this.getProcess().getMacroHandler().addMacro(iterationMacroName, name);
            this.currentName = name;
            this.applyInnerOperators(exampleSet);
            ++this.iteration;
        }
        this.getProcess().getMacroHandler().removeMacro(iterationMacroName);
        return new IOObject[]{exampleSet};
    }

    private boolean acceptPattern(Attribute attribute, Pattern pattern, boolean invertSelection) {
        if (!invertSelection) {
            if (pattern != null) {
                Matcher matcher = pattern.matcher(attribute.getName());
                return matcher.matches();
            }
            return true;
        }
        if (pattern != null) {
            Matcher matcher = pattern.matcher(attribute.getName());
            return !matcher.matches();
        }
        return true;
    }

    private boolean acceptType(Attribute attribute, int typeFilter, boolean invertSelection) {
        if (!invertSelection) {
            switch (typeFilter) {
                case 2: {
                    return attribute.isNumerical();
                }
                case 1: {
                    return attribute.isNominal();
                }
            }
            return true;
        }
        switch (typeFilter) {
            case 2: {
                return !attribute.isNumerical();
            }
            case 1: {
                return !attribute.isNominal();
            }
        }
        return true;
    }

    private void applyInnerOperators(ExampleSet exampleSet) throws OperatorException {
        ExampleSet set = this.getParameterAsBoolean(PARAMETER_WORK_ON_INPUT) ? (ExampleSet)exampleSet.clone() : exampleSet;
        IOContainer input = new IOContainer(set);
        int i = 0;
        while (i < this.getNumberOfOperators()) {
            input = this.getOperator(i).apply(input);
            ++i;
        }
    }

    @Override
    public InnerOperatorCondition getInnerOperatorCondition() {
        return new LastInnerOperatorCondition(new Class[]{ExampleSet.class}, new Class[0]);
    }

    @Override
    public int getMaxNumberOfInnerOperators() {
        return Integer.MAX_VALUE;
    }

    @Override
    public int getMinNumberOfInnerOperators() {
        return 1;
    }

    @Override
    public Class<?>[] getInputClasses() {
        return new Class[]{ExampleSet.class};
    }

    @Override
    public Class<?>[] getOutputClasses() {
        return new Class[]{ExampleSet.class};
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        types.add(new ParameterTypeString(PARAMETER_FILTER, "A regular expression which can be used to filter the features in this loop, i.e. the inner operators are only applied to features which name fulfills the filter expression.", true));
        types.add(new ParameterTypeCategory(PARAMETER_TYPE_FILTER, "Indicates if a value type filter should be applied for this loop.", TYPE_FILTERS, 0));
        types.add(new ParameterTypeBoolean(PARAMETER_WORK_ON_SPECIAL, "Indicates if this operator should also work on special attributes.", false));
        types.add(new ParameterTypeBoolean(PARAMETER_INVERT_SELECTION, "Indicates if the filter settings should be inverted, i.e. the loop will run over all features not fulfilling the specified criteria.", false));
        types.add(new ParameterTypeString(PARAMETER_ITERATION_MACRO, "The name of the macro which holds the name of the current feature in each iteration.", DEFAULT_ITERATION_MACRO_NAME));
        types.add(new ParameterTypeBoolean(PARAMETER_WORK_ON_INPUT, "Specifies if the inner operators work on a copy of the input exampleset so that the operator returns the original input example set attributes without changes. Note that changing attribute values will change original example set's values.", true));
        return types;
    }
}

