/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.preprocessing.filter;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.table.AttributeFactory;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.preprocessing.AbstractDataProcessing;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeString;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NominalNumbers2Numerical
extends AbstractDataProcessing {
    public static final String PARAMETER_DECIMAL_POINT_CHARACTER = "decimal_point_character";

    public NominalNumbers2Numerical(OperatorDescription description) {
        super(description);
    }

    @Override
    public ExampleSet apply(ExampleSet exampleSet) throws OperatorException {
        char decimalPointCharacter = this.getParameterAsString(PARAMETER_DECIMAL_POINT_CHARACTER).charAt(0);
        LinkedList<Attribute> newAttributes = new LinkedList<Attribute>();
        Iterator<Attribute> a = exampleSet.getAttributes().iterator();
        while (a.hasNext()) {
            Attribute attribute = a.next();
            if (!attribute.isNominal()) continue;
            boolean isNumericalNominal = true;
            try {
                for (String value : attribute.getMapping().getValues()) {
                    String checkValue = value.replace(decimalPointCharacter, '.');
                    Double.parseDouble(checkValue);
                }
            }
            catch (Exception e) {
                isNumericalNominal = false;
            }
            if (!isNumericalNominal) continue;
            Attribute newAttribute = AttributeFactory.createAttribute(2);
            exampleSet.getExampleTable().addAttribute(newAttribute);
            newAttributes.add(newAttribute);
            for (Example e : exampleSet) {
                double oldValue = e.getValue(attribute);
                if (!Double.isNaN(oldValue)) {
                    String value = e.getValueAsString(attribute);
                    String replaceValue = value.replace(decimalPointCharacter, '.');
                    e.setValue(newAttribute, Double.parseDouble(replaceValue));
                    continue;
                }
                e.setValue(newAttribute, Double.NaN);
            }
            exampleSet.getExampleTable().removeAttribute(attribute);
            a.remove();
            newAttribute.setName(attribute.getName());
        }
        for (Attribute attribute : newAttributes) {
            exampleSet.getAttributes().addRegular(attribute);
        }
        return exampleSet;
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        types.add(new ParameterTypeString(PARAMETER_DECIMAL_POINT_CHARACTER, "Character that is used as decimal point.", "."));
        return types;
    }
}

