/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.preprocessing.filter;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.Example;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.preprocessing.filter.NumericToNominal;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeBoolean;
import com.rapidminer.parameter.ParameterTypeCategory;
import com.rapidminer.parameter.ParameterTypeSingle;
import com.rapidminer.parameter.ParameterTypeString;
import com.rapidminer.parameter.conditions.EqualTypeCondition;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NumericToFormattedNominal
extends NumericToNominal {
    public static final String PARAMETER_FORMAT_TYPE = "format_type";
    public static final String PARAMETER_PATTERN = "pattern";
    public static final String PARAMETER_LOCALE = "locale";
    public static final String PARAMETER_USE_GROUPING = "use_grouping";
    public static final String[] FORMAT_TYPES;
    public static final int FORMAT_TYPE_NUMBER = 0;
    public static final int FORMAT_TYPE_INTEGER = 1;
    public static final int FORMAT_TYPE_CURRENCY = 2;
    public static final int FORMAT_TYPE_PERCENT = 3;
    public static final int FORMAT_TYPE_PATTERN = 4;
    public static List<Locale> availableLocales;
    public static String[] availableLocaleNames;
    public static int defaultLocale;
    private NumberFormat numberFormat;

    static {
        Locale[] availableLocaleArray;
        FORMAT_TYPES = new String[]{"number", "integer", "currency", "percent", PARAMETER_PATTERN};
        availableLocales = new ArrayList<Locale>();
        Locale[] localeArray = availableLocaleArray = Locale.getAvailableLocales();
        int n = availableLocaleArray.length;
        int n2 = 0;
        while (n2 < n) {
            Locale l = localeArray[n2];
            availableLocales.add(l);
            ++n2;
        }
        Collections.sort(availableLocales, new Comparator<Locale>(){

            @Override
            public int compare(Locale o1, Locale o2) {
                return o1.getDisplayName().compareTo(o2.getDisplayName());
            }
        });
        availableLocaleNames = new String[availableLocales.size()];
        defaultLocale = -1;
        int i = 0;
        while (i < availableLocales.size()) {
            Locale currentLocale = availableLocales.get(i);
            NumericToFormattedNominal.availableLocaleNames[i] = currentLocale.getDisplayName();
            if (currentLocale.equals(Locale.US)) {
                defaultLocale = i;
            }
            ++i;
        }
        if (defaultLocale < 0) {
            defaultLocale = 0;
        }
    }

    public NumericToFormattedNominal(OperatorDescription description) {
        super(description);
    }

    @Override
    public void init() throws OperatorException {
        int localeIndex = this.getParameterAsInt(PARAMETER_LOCALE);
        Locale selectedLocale = Locale.US;
        if (localeIndex >= 0 && localeIndex < availableLocales.size()) {
            selectedLocale = availableLocales.get(this.getParameterAsInt(PARAMETER_LOCALE));
        }
        int formatType = this.getParameterAsInt(PARAMETER_FORMAT_TYPE);
        switch (formatType) {
            case 0: {
                this.numberFormat = NumberFormat.getNumberInstance(selectedLocale);
                break;
            }
            case 1: {
                this.numberFormat = NumberFormat.getIntegerInstance(selectedLocale);
                break;
            }
            case 2: {
                this.numberFormat = NumberFormat.getCurrencyInstance(selectedLocale);
                break;
            }
            case 3: {
                this.numberFormat = NumberFormat.getPercentInstance(selectedLocale);
                break;
            }
            case 4: {
                String formatString = this.getParameterAsString(PARAMETER_PATTERN);
                this.numberFormat = new DecimalFormat(formatString, new DecimalFormatSymbols(selectedLocale));
            }
        }
        this.numberFormat.setGroupingUsed(this.getParameterAsBoolean(PARAMETER_USE_GROUPING));
    }

    @Override
    public void cleanUp() throws OperatorException {
        this.numberFormat = null;
    }

    @Override
    protected void setValue(Example example, Attribute newAttribute, double value) {
        if (Double.isNaN(value)) {
            example.setValue(newAttribute, Double.NaN);
        } else {
            String newValue = this.numberFormat.format(value);
            example.setValue(newAttribute, newAttribute.getMapping().mapString(newValue));
        }
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        ParameterTypeSingle type = new ParameterTypeCategory(PARAMETER_FORMAT_TYPE, "Number formatting will be performed according to the selected type.", FORMAT_TYPES, 0);
        types.add(type);
        type = new ParameterTypeString(PARAMETER_PATTERN, "The format string, e.g. '0.###E0 m/s'.", true);
        type.registerDependencyCondition(new EqualTypeCondition(this, PARAMETER_FORMAT_TYPE, true, 4));
        types.add(type);
        type = new ParameterTypeCategory(PARAMETER_LOCALE, "The used locale for date texts, for example \"Wed\" (English) in contrast to \"Mi\" (German).", availableLocaleNames, defaultLocale);
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeBoolean(PARAMETER_USE_GROUPING, "Indicates if a grouping character should be used for larger numbers (e.g. ',' for the US or '.' for Germany).", false);
        type.setExpert(false);
        types.add(type);
        return types;
    }

    @Override
    protected int getGeneratedAttributevalueType() {
        return 1;
    }
}

