/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.preprocessing.series;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.table.AttributeFactory;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.preprocessing.series.AbstractSeriesProcessing;
import java.util.Iterator;

public class LabelTrend2Classification
extends AbstractSeriesProcessing {
    public LabelTrend2Classification(OperatorDescription description) {
        super(description);
    }

    public ExampleSet apply(ExampleSet exampleSet) throws OperatorException {
        Attribute label = exampleSet.getAttributes().getLabel();
        if (label == null) {
            throw new UserError(this, 105);
        }
        if (!label.isNumerical()) {
            throw new UserError((Operator)this, 102, this.getName(), label.getName());
        }
        Attribute newLabel = AttributeFactory.createAttribute(6);
        newLabel.getMapping().mapString("up");
        newLabel.getMapping().mapString("down");
        exampleSet.getExampleTable().addAttribute(newLabel);
        exampleSet.getAttributes().addRegular(newLabel);
        Iterator i = exampleSet.iterator();
        double lastValue = 0.0;
        while (i.hasNext()) {
            Example example = (Example)i.next();
            double currentValue = example.getLabel();
            if (currentValue > lastValue) {
                example.setValue(newLabel, "up");
            } else {
                example.setValue(newLabel, "down");
            }
            lastValue = currentValue;
        }
        exampleSet.getAttributes().remove(newLabel);
        exampleSet.getAttributes().setLabel(newLabel);
        newLabel.setName("label");
        return exampleSet;
    }
}

