/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.preprocessing.series.filter;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.preprocessing.series.AbstractSeriesProcessing;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeCategory;
import com.rapidminer.parameter.ParameterTypeDouble;
import com.rapidminer.parameter.ParameterTypeSingle;
import com.rapidminer.parameter.ParameterTypeString;
import com.rapidminer.parameter.conditions.EqualTypeCondition;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SeriesMissingValueReplenishment
extends AbstractSeriesProcessing {
    public static final String PARAMETER_ATTRIBUTE_NAME = "attribute_name";
    public static final String PARAMETER_REPLACEMENT = "replacement";
    public static final String[] REPLACEMENTS = new String[]{"previous value", "next value", "value", "linear interpolation"};
    public static final int REPLACE_BY_PREVIOUS_VALUE = 0;
    public static final int REPLACE_BY_NEXT_VALUE = 1;
    public static final int REPLACE_BY_VALUE = 2;
    public static final int LINEAR_INTERPOLATION = 3;
    public static final String PARAMETER_VALUE = "value";

    public SeriesMissingValueReplenishment(OperatorDescription description) {
        super(description);
    }

    @Override
    public ExampleSet apply(ExampleSet exampleSet) throws OperatorException {
        Attribute attribute = exampleSet.getAttributes().get(this.getParameterAsString(PARAMETER_ATTRIBUTE_NAME));
        int replacement = this.getParameterAsInt(PARAMETER_REPLACEMENT);
        switch (replacement) {
            case 0: {
                double replacementValue = Double.NaN;
                for (Example example : exampleSet) {
                    double value = example.getValue(attribute);
                    if (Double.isNaN(value)) {
                        example.setValue(attribute, replacementValue);
                        continue;
                    }
                    replacementValue = value;
                }
                break;
            }
            case 1: {
                LinkedList<Example> missingExamples = new LinkedList<Example>();
                for (Example example : exampleSet) {
                    double value = example.getValue(attribute);
                    if (Double.isNaN(value)) {
                        missingExamples.add(example);
                        continue;
                    }
                    for (Example missingExample : missingExamples) {
                        missingExample.setValue(attribute, value);
                    }
                    missingExamples.clear();
                }
                break;
            }
            case 2: {
                double value = this.getParameterAsDouble(PARAMETER_VALUE);
                for (Example example : exampleSet) {
                    if (!Double.isNaN(example.getValue(attribute))) continue;
                    example.setValue(attribute, value);
                }
                break;
            }
            case 3: {
                LinkedList<Example> missingExamples = new LinkedList<Example>();
                double lastValue = Double.NaN;
                for (Example example : exampleSet) {
                    double value = example.getValue(attribute);
                    if (Double.isNaN(value)) {
                        missingExamples.add(example);
                        continue;
                    }
                    if (missingExamples.size() > 0 && !Double.isNaN(lastValue)) {
                        double stepSize = (value - lastValue) / (double)(missingExamples.size() + 1);
                        for (Example missingExample : missingExamples) {
                            missingExample.setValue(attribute, lastValue += stepSize);
                        }
                        missingExamples.clear();
                    }
                    lastValue = value;
                }
                break;
            }
        }
        exampleSet.recalculateAttributeStatistics(attribute);
        return exampleSet;
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        ParameterTypeSingle type = new ParameterTypeString(PARAMETER_ATTRIBUTE_NAME, "The name of the series attribute.", false);
        types.add(type);
        type = new ParameterTypeCategory(PARAMETER_REPLACEMENT, "Specifies how the missing series value should be replaced.", REPLACEMENTS, 0);
        types.add(type);
        type = new ParameterTypeDouble(PARAMETER_VALUE, "The value by which the missings should be replaced.", Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY);
        type.registerDependencyCondition(new EqualTypeCondition(this, PARAMETER_REPLACEMENT, true, 2));
        types.add(type);
        return types;
    }
}

