/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.tools.math.function.aggregation;

import com.rapidminer.example.Attribute;
import com.rapidminer.tools.math.function.aggregation.AbstractAggregationFunction;

public class SumFunction
extends AbstractAggregationFunction {
    private double valueSum;

    public SumFunction() {
        this(true);
    }

    public SumFunction(Boolean ignoreMissings) {
        super(ignoreMissings);
    }

    public String getName() {
        return "sum";
    }

    protected void reset() {
        this.foundMissing = false;
        this.valueSum = 0.0;
    }

    public void update(double value, double weight) {
        if (Double.isNaN(value)) {
            this.foundMissing = true;
            return;
        }
        this.valueSum += value * weight;
    }

    public void update(double value) {
        if (Double.isNaN(value)) {
            this.foundMissing = true;
            return;
        }
        this.valueSum += value;
    }

    public double getValue() {
        if (this.foundMissing && !this.ignoreMissings) {
            return Double.NaN;
        }
        return this.valueSum;
    }

    public boolean supportsAttribute(Attribute attribute) {
        return attribute.isNumerical();
    }
}

