/*
 * Decompiled with CFR 0.152.
 */
package de.dfki.lt.tools.tokenizer.regexp;

import de.dfki.lt.tools.tokenizer.exceptions.InitializationException;
import de.dfki.lt.tools.tokenizer.regexp.Match;
import de.dfki.lt.tools.tokenizer.regexp.RegExp;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

public class JavaRegExp
implements RegExp {
    private Pattern javaRE;

    private JavaRegExp() {
    }

    public JavaRegExp(String regExpString) throws InitializationException {
        try {
            this.setJavaRE(Pattern.compile(regExpString));
        }
        catch (PatternSyntaxException pse) {
            throw new InitializationException(pse.toString());
        }
    }

    private Pattern getJavaRE() {
        return this.javaRE;
    }

    private void setJavaRE(Pattern aJavaRE) {
        this.javaRE = aJavaRE;
    }

    @Override
    public List getAllMatches(String input) {
        Matcher javaMatch = this.getJavaRE().matcher(input);
        ArrayList<Match> matches = new ArrayList<Match>();
        while (javaMatch.find()) {
            matches.add(new Match(javaMatch.start(), javaMatch.end(), javaMatch.group()));
        }
        return matches;
    }

    @Override
    public boolean matches(String input) {
        Matcher javaMatch = this.getJavaRE().matcher(input);
        return javaMatch.matches();
    }

    @Override
    public Match contains(String input) {
        Matcher javaMatch = this.getJavaRE().matcher(input);
        if (javaMatch.find()) {
            return new Match(javaMatch.start(), javaMatch.end(), javaMatch.group());
        }
        return null;
    }
}

