/*
 * Decompiled with CFR 0.152.
 */
package marytts.modules;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Scanner;
import java.util.Vector;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import marytts.datatypes.MaryData;
import marytts.datatypes.MaryDataType;
import marytts.exceptions.SynthesisException;
import marytts.features.FeatureDefinition;
import marytts.features.FeatureVector;
import marytts.htsengine.CartTreeSet;
import marytts.htsengine.HMMData;
import marytts.htsengine.HMMVoice;
import marytts.htsengine.HTSEngineTest;
import marytts.htsengine.HTSModel;
import marytts.htsengine.HTSParameterGeneration;
import marytts.htsengine.HTSUttModel;
import marytts.htsengine.HTSVocoder;
import marytts.modules.InternalModule;
import marytts.modules.synthesis.Voice;
import marytts.unitselection.select.Target;
import marytts.util.MaryUtils;
import marytts.util.data.audio.AppendableSequenceAudioInputStream;
import marytts.util.data.audio.AudioPlayer;
import marytts.util.dom.MaryDomUtils;
import org.apache.log4j.BasicConfigurator;
import org.apache.log4j.Logger;
import org.w3c.dom.Element;
import org.w3c.dom.traversal.NodeIterator;

public class HTSEngine
extends InternalModule {
    private Logger loggerHts = MaryUtils.getLogger("HTSEngine");
    private String realisedDurations;
    private boolean phoneAlignmentForDurations = false;
    private boolean stateAlignmentForDurations = false;
    private Vector<HTSEngineTest.PhonemeDuration> alignDur = null;
    private double newStateDurationFactor = 0.5;

    public String getRealisedDurations() {
        return this.realisedDurations;
    }

    public boolean getPhonemeAlignmentForDurations() {
        return this.phoneAlignmentForDurations;
    }

    public boolean getStateAlignmentForDurations() {
        return this.stateAlignmentForDurations;
    }

    public Vector<HTSEngineTest.PhonemeDuration> getAlignDurations() {
        return this.alignDur;
    }

    public double getNewStateDurationFactor() {
        return this.newStateDurationFactor;
    }

    public void setRealisedDurations(String str) {
        this.realisedDurations = str;
    }

    public void setStateAlignmentForDurations(boolean bval) {
        this.stateAlignmentForDurations = bval;
    }

    public void setPhonemeAlignmentForDurations(boolean bval) {
        this.phoneAlignmentForDurations = bval;
    }

    public void setAlignDurations(Vector<HTSEngineTest.PhonemeDuration> val) {
        this.alignDur = val;
    }

    public void setNewStateDurationFactor(double dval) {
        this.newStateDurationFactor = dval;
    }

    public HTSEngine() {
        super("HTSEngine", MaryDataType.TARGETFEATURES, MaryDataType.AUDIO, null);
    }

    @Override
    public synchronized void powerOnSelfTest() throws Error {
    }

    public MaryData process(MaryData d, List<Target> targetFeaturesList, List<Element> segmentsAndBoundaries, List<Element> tokensAndBoundaries) throws Exception {
        HTSUttModel um = new HTSUttModel();
        HTSParameterGeneration pdf2par = new HTSParameterGeneration();
        HTSVocoder par2speech = new HTSVocoder();
        Voice v = d.getDefaultVoice();
        assert (v instanceof HMMVoice);
        HMMVoice hmmv = (HMMVoice)v;
        this.processTargetList(targetFeaturesList, segmentsAndBoundaries, um, hmmv.getHMMData());
        boolean debug = false;
        pdf2par.htsMaximumLikelihoodParameterGeneration(um, hmmv.getHMMData(), "", debug);
        AudioInputStream ais = par2speech.htsMLSAVocoder(pdf2par, hmmv.getHMMData());
        MaryData output = new MaryData(this.outputType(), d.getLocale());
        if (d.getAudioFileFormat() != null) {
            output.setAudioFileFormat(d.getAudioFileFormat());
            if (d.getAudio() != null) {
                assert (d.getAudio() instanceof AppendableSequenceAudioInputStream);
                output.setAudio(d.getAudio());
            }
        }
        output.appendAudio(ais);
        if (tokensAndBoundaries != null) {
            this.setRealisedProsody(tokensAndBoundaries, um);
        }
        return output;
    }

    public void setRealisedProsody(List<Element> tokensAndBoundaries, HTSUttModel um) throws SynthesisException {
        Object s = null;
        float totalDur = 0.0f;
        int numModel = 0;
        for (Element e : tokensAndBoundaries) {
            HTSModel m;
            if (e.getTagName().equals("t")) {
                Element phone;
                NodeIterator nIt = MaryDomUtils.createNodeIterator(e, "ph");
                while ((phone = (Element)nIt.nextNode()) != null) {
                    String p = phone.getAttribute("p");
                    m = um.getUttModel(numModel++);
                    phone.setAttribute("d", m.getMaryXmlDur());
                    phone.setAttribute("end", String.valueOf(totalDur += (float)m.getTotalDurMillisec() * 0.001f));
                    phone.setAttribute("f0", m.getMaryXmlF0());
                }
                continue;
            }
            if (!e.getTagName().contentEquals("boundary")) continue;
            int breakindex = 0;
            try {
                breakindex = Integer.parseInt(e.getAttribute("breakindex"));
            }
            catch (NumberFormatException nfe) {
                // empty catch block
            }
            if (!e.hasAttribute("duration") && breakindex < 3 || !(m = um.getUttModel(numModel++)).getPhoneName().contentEquals("_")) continue;
            int currentDur = m.getTotalDurMillisec();
            totalDur += (float)currentDur * 0.001f;
            e.setAttribute("duration", String.valueOf(currentDur));
        }
    }

    public void processUttFromFile(String feaFile, HTSUttModel um, HMMData htsData) throws Exception {
        List<Target> targetFeaturesList = this.getTargetsFromFile(feaFile, htsData);
        this.processTargetList(targetFeaturesList, null, um, htsData);
    }

    public AudioInputStream processStr(String context, HMMData htsData) throws Exception {
        HTSUttModel um = new HTSUttModel();
        HTSParameterGeneration pdf2par = new HTSParameterGeneration();
        HTSVocoder par2speech = new HTSVocoder();
        List<Target> targetFeaturesList = this.getTargetsFromText(context, htsData);
        this.processTargetList(targetFeaturesList, null, um, htsData);
        boolean debug = false;
        pdf2par.htsMaximumLikelihoodParameterGeneration(um, htsData, "", debug);
        AudioInputStream ais = par2speech.htsMLSAVocoder(pdf2par, htsData);
        return ais;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Target> getTargetsFromFile(String LabFile, HMMData htsData) throws Exception {
        List<Target> targets = null;
        Scanner s = null;
        try {
            s = new Scanner(new BufferedReader(new FileReader(LabFile)));
            targets = this.getTargets(s, htsData);
        }
        catch (FileNotFoundException e) {
            System.err.println("FileNotFoundException: " + e.getMessage());
        }
        finally {
            if (s != null) {
                s.close();
            }
        }
        return targets;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Target> getTargetsFromText(String LabText, HMMData htsData) throws Exception {
        List<Target> targets;
        Scanner s = null;
        try {
            s = new Scanner(LabText);
            targets = this.getTargets(s, htsData);
        }
        finally {
            if (s != null) {
                s.close();
            }
        }
        return targets;
    }

    public List<Target> getTargets(Scanner s, HMMData htsData) {
        String nextLine;
        FeatureDefinition feaDef = htsData.getFeatureDefinition();
        ArrayList<Target> targets = new ArrayList<Target>();
        while (s.hasNext() && !(nextLine = s.nextLine()).trim().equals("")) {
        }
        int numLines = 0;
        while (s.hasNext() && !(nextLine = s.nextLine()).trim().equals("")) {
            ++numLines;
        }
        boolean i = false;
        while (s.hasNext()) {
            nextLine = s.nextLine();
            FeatureVector fv = feaDef.toFeatureVector(0, nextLine);
            Target t = new Target(fv.getFeatureAsString(feaDef.getFeatureIndex("phone"), feaDef), null);
            t.setFeatureVector(fv);
            targets.add(t);
        }
        return targets;
    }

    private void processTargetList(List<Target> targetFeaturesList, List<Element> segmentsAndBoundaries, HTSUttModel um, HMMData htsData) throws Exception {
        HTSModel m;
        CartTreeSet cart = htsData.getCartTreeSet();
        this.realisedDurations = "#\n";
        Integer numLab = 0;
        double diffdurOld = 0.0;
        double diffdurNew = 0.0;
        int alignDurSize = 0;
        float fperiodmillisec = (float)htsData.getFperiod() / (float)htsData.getRate() * 1000.0f;
        float fperiodsec = (float)htsData.getFperiod() / (float)htsData.getRate();
        boolean firstPh = true;
        boolean lastPh = false;
        float durVal = 0.0f;
        FeatureDefinition feaDef = htsData.getFeatureDefinition();
        if (htsData.getUseAcousticModels()) {
            this.phoneAlignmentForDurations = true;
            this.loggerHts.info("Using prosody from acoustparams.");
        } else {
            this.phoneAlignmentForDurations = false;
            this.loggerHts.info("Estimating state durations from (Gaussian) state duration model.");
        }
        int i = 0;
        for (Target target : targetFeaturesList) {
            FeatureVector fv = target.getFeatureVector();
            um.addUttModel(new HTSModel(cart.getNumStates()));
            m = um.getUttModel(i);
            m.setPhoneName(fv.getFeatureAsString(feaDef.getFeatureIndex("phone"), feaDef));
            if (htsData.getUseContextDependentGV() && m.getPhoneName().contentEquals("_")) {
                m.setGvSwitch(false);
            }
            if (this.phoneAlignmentForDurations && segmentsAndBoundaries != null) {
                int newStateDuration;
                int k;
                double durationsFraction;
                Element e = segmentsAndBoundaries.get(i);
                diffdurNew = cart.searchDurInCartTree(m, fv, htsData, firstPh, lastPh, diffdurOld);
                if (e.getTagName().contentEquals("ph")) {
                    m.setMaryXmlDur(e.getAttribute("d"));
                    durVal = Float.parseFloat(m.getMaryXmlDur());
                    durationsFraction = durVal / (fperiodmillisec * (float)m.getTotalDur());
                    m.setTotalDur(0);
                    for (k = 0; k < cart.getNumStates(); ++k) {
                        newStateDuration = (int)(durationsFraction * (double)m.getDur(k) + this.newStateDurationFactor);
                        if (newStateDuration <= 0) {
                            newStateDuration = 1;
                        }
                        m.setDur(k, newStateDuration);
                        m.setTotalDur(m.getTotalDur() + m.getDur(k));
                    }
                } else if (e.getTagName().contentEquals("boundary")) {
                    durVal = 0.0f;
                    if (!e.getAttribute("duration").isEmpty()) {
                        durVal = Float.parseFloat(e.getAttribute("duration"));
                    }
                    if (durVal != 400.0f) {
                        int durValFrames = Math.round(durVal / fperiodmillisec);
                        int totalDurGaussians = m.getTotalDur();
                        m.setTotalDur(durValFrames);
                        durationsFraction = durVal / (fperiodmillisec * (float)m.getTotalDur());
                        m.setTotalDur(0);
                        for (k = 0; k < cart.getNumStates(); ++k) {
                            newStateDuration = Math.round((float)m.getDur(k) / (float)totalDurGaussians * (float)durValFrames);
                            if (newStateDuration <= 0) {
                                newStateDuration = 1;
                            }
                            m.setDur(k, newStateDuration);
                            m.setTotalDur(m.getTotalDur() + m.getDur(k));
                        }
                    } else {
                        if (!e.getAttribute("breakindex").isEmpty()) {
                            durVal = Float.parseFloat(e.getAttribute("breakindex"));
                        }
                        durVal = (float)m.getTotalDur() * fperiodmillisec;
                    }
                    m.setMaryXmlDur(Float.toString(durVal));
                }
                if (e.hasAttribute("f0")) {
                    m.setMaryXmlF0(e.getAttribute("f0"));
                }
            } else {
                diffdurNew = cart.searchDurInCartTree(m, fv, htsData, firstPh, lastPh, diffdurOld);
            }
            um.setTotalFrame(um.getTotalFrame() + m.getTotalDur());
            m.setTotalDurMillisec((int)(fperiodmillisec * (float)m.getTotalDur()));
            Float durSec = Float.valueOf((float)um.getTotalFrame() * fperiodsec);
            this.realisedDurations = this.realisedDurations + durSec.toString() + " " + numLab.toString() + " " + m.getPhoneName() + "\n";
            Integer n = numLab;
            Integer n2 = numLab = Integer.valueOf(numLab + 1);
            diffdurOld = diffdurNew;
            cart.searchLf0InCartTree(m, fv, feaDef, htsData.getUV());
            cart.searchMgcInCartTree(m, fv, feaDef);
            if (htsData.getTreeStrStream() != null) {
                cart.searchStrInCartTree(m, fv, feaDef);
            }
            if (htsData.getTreeMagStream() != null) {
                cart.searchMagInCartTree(m, fv, feaDef);
            }
            um.setNumModel(um.getNumModel() + 1);
            um.setNumState(um.getNumState() + cart.getNumStates());
            ++i;
            if (!firstPh) continue;
            firstPh = false;
        }
        if (this.phoneAlignmentForDurations && this.alignDur != null && um.getNumUttModel() != alignDurSize) {
            throw new Exception("The number of durations provided for phone alignment (" + alignDurSize + ") is greater than the number of feature vectors (" + um.getNumUttModel() + ").");
        }
        for (i = 0; i < um.getNumUttModel(); ++i) {
            m = um.getUttModel(i);
            for (int mstate = 0; mstate < cart.getNumStates(); ++mstate) {
                for (int frame = 0; frame < m.getDur(mstate); ++frame) {
                    if (!m.getVoiced(mstate)) continue;
                    um.setLf0Frame(um.getLf0Frame() + 1);
                }
            }
        }
        this.loggerHts.info("Number of models in sentence numModel=" + um.getNumModel() + "  Total number of states numState=" + um.getNumState());
        this.loggerHts.info("Total number of frames=" + um.getTotalFrame() + "  Number of voiced frames=" + um.getLf0Frame());
    }

    public static void main(String[] args) throws IOException, InterruptedException, Exception {
        BasicConfigurator.configure();
        HTSEngine hmm_tts = new HTSEngine();
        HMMData htsData = new HMMData();
        String MaryBase = "/project/mary/marcela/marytts/";
        String voiceDir = MaryBase + "voice-cmu-slt-hsmm/src/main/resources/";
        String voiceName = "cmu-slt-hsmm";
        String voiceConfig = "marytts/voice/CmuSltHsmm/voice.config";
        String durFile = MaryBase + "tmp/tmp.lab";
        String parFile = MaryBase + "tmp/tmp";
        String outWavFile = MaryBase + "tmp/tmp.wav";
        htsData.initHMMData(voiceName, voiceDir, voiceConfig);
        htsData.setUseGV(true);
        htsData.setUseMixExc(true);
        htsData.setUseAcousticModels(false);
        HTSUttModel um = new HTSUttModel();
        HTSParameterGeneration pdf2par = new HTSParameterGeneration();
        HTSVocoder par2speech = new HTSVocoder();
        String feaFile = voiceDir + "marytts/voice/CmuSltHsmm/cmu_us_arctic_slt_b0487.pfeats";
        try {
            hmm_tts.processUttFromFile(feaFile, um, htsData);
            FileWriter outputStream = new FileWriter(durFile);
            outputStream.write(hmm_tts.realisedDurations);
            outputStream.close();
            boolean debug = true;
            pdf2par.htsMaximumLikelihoodParameterGeneration(um, htsData, parFile, debug);
            AudioInputStream ais = par2speech.htsMLSAVocoder(pdf2par, htsData);
            System.out.println("Saving to file: " + outWavFile);
            System.out.println("Realised durations saved to file: " + durFile);
            File fileOut = new File(outWavFile);
            if (AudioSystem.isFileTypeSupported(AudioFileFormat.Type.WAVE, ais)) {
                AudioSystem.write(ais, AudioFileFormat.Type.WAVE, fileOut);
            }
            System.out.println("Calling audioplayer:");
            AudioPlayer player = new AudioPlayer(fileOut);
            player.start();
            player.join();
            System.out.println("Audioplayer finished...");
        }
        catch (Exception e) {
            System.err.println("Exception: " + e.getMessage());
        }
    }
}

