/*
 * Decompiled with CFR 0.152.
 */
package marytts.server.http;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import marytts.server.http.MaryHttpServerUtils;
import marytts.util.MaryUtils;
import marytts.util.http.Address;
import org.apache.http.Header;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpException;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.MethodNotSupportedException;
import org.apache.http.nio.ContentDecoder;
import org.apache.http.nio.ContentDecoderChannel;
import org.apache.http.nio.FileContentDecoder;
import org.apache.http.nio.IOControl;
import org.apache.http.nio.entity.ConsumingNHttpEntity;
import org.apache.http.nio.entity.ConsumingNHttpEntityTemplate;
import org.apache.http.nio.entity.ContentListener;
import org.apache.http.nio.protocol.SimpleNHttpRequestHandler;
import org.apache.http.protocol.HttpContext;
import org.apache.http.protocol.HttpRequestHandler;
import org.apache.http.util.EntityUtils;
import org.apache.log4j.Logger;

public abstract class BaseHttpRequestHandler
extends SimpleNHttpRequestHandler
implements HttpRequestHandler {
    private final boolean useFileChannels = true;
    protected static Logger logger;
    private int runningNumber = 1;
    private Map<String, Object[]> requestMap;

    public BaseHttpRequestHandler() {
        logger = MaryUtils.getLogger("server");
        this.requestMap = Collections.synchronizedMap(new HashMap());
    }

    @Override
    public void handle(HttpRequest request, HttpResponse response, HttpContext context) throws HttpException, IOException {
        try {
            Header[] tmp = request.getHeaders("Host");
            Address serverAddressAtClient = this.getServerAddressAtClient(tmp[0].getValue());
            String uri = request.getRequestLine().getUri();
            String method = request.getRequestLine().getMethod().toUpperCase(Locale.ENGLISH);
            if (!method.equals("GET") && !method.equals("POST")) {
                throw new MethodNotSupportedException(method + " method not supported");
            }
            String absPath = null;
            String query = null;
            if (uri != null && uri.length() > 0) {
                if (!uri.startsWith("/")) {
                    throw new HttpException("Unexpected uri: '" + uri + "' does not start with a slash");
                }
                int q = uri.indexOf(63);
                if (q == -1) {
                    absPath = uri;
                } else {
                    absPath = uri.substring(0, q);
                    query = uri.substring(q + 1);
                }
            }
            Map<String, String> queryItems = null;
            if (query != null && query.length() > 0) {
                queryItems = MaryHttpServerUtils.toKeyValuePairs(query, true);
            }
            if (method.equals("POST") && queryItems == null && request instanceof HttpEntityEnclosingRequest) {
                try {
                    String postQuery = EntityUtils.toString(((HttpEntityEnclosingRequest)request).getEntity());
                    queryItems = MaryHttpServerUtils.toKeyValuePairs(postQuery, true);
                }
                catch (Exception e) {
                    logger.debug("Cannot read post query", e);
                    MaryHttpServerUtils.errorInternalServerError(response, "Cannot read post query", e);
                }
            }
            this.handleClientRequest(absPath, queryItems, response, serverAddressAtClient);
        }
        catch (RuntimeException re) {
            logger.warn("runtime exception in handle():", re);
        }
    }

    protected abstract void handleClientRequest(String var1, Map<String, String> var2, HttpResponse var3, Address var4) throws IOException;

    protected Address getServerAddressAtClient(String fullHeader) {
        String fullAddress = fullHeader.trim();
        int index = fullAddress.indexOf(63);
        if (index > 0) {
            fullAddress = fullAddress.substring(0, index);
        }
        return new Address(fullAddress);
    }

    @Override
    public ConsumingNHttpEntity entityRequest(HttpEntityEnclosingRequest request, HttpContext context) throws HttpException, IOException {
        return new ConsumingNHttpEntityTemplate(request.getEntity(), new FileWriteListener(true));
    }

    static class FileWriteListener
    implements ContentListener {
        private final File file = File.createTempFile("tmp", ".tmp", null);
        private final FileInputStream inputFile = new FileInputStream(this.file);
        private final FileChannel fileChannel = this.inputFile.getChannel();
        private final boolean useFileChannels;
        private long idx = 0L;

        public FileWriteListener(boolean useFileChannels) throws IOException {
            this.useFileChannels = useFileChannels;
        }

        @Override
        public void contentAvailable(ContentDecoder decoder, IOControl ioctrl) throws IOException {
            long transferred = this.useFileChannels && decoder instanceof FileContentDecoder ? ((FileContentDecoder)decoder).transfer(this.fileChannel, this.idx, Long.MAX_VALUE) : this.fileChannel.transferFrom(new ContentDecoderChannel(decoder), this.idx, Long.MAX_VALUE);
            if (transferred > 0L) {
                this.idx += transferred;
            }
        }

        @Override
        public void finished() {
            try {
                this.inputFile.close();
            }
            catch (IOException ignored) {
                // empty catch block
            }
            try {
                this.fileChannel.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

