/*
 * Decompiled with CFR 0.152.
 */
package marytts.unitselection.data;

import java.util.Iterator;
import java.util.NoSuchElementException;
import marytts.features.FeatureDefinition;
import marytts.features.FeatureVector;
import marytts.unitselection.data.FeatureFileReader;
import marytts.unitselection.data.Syllable;

public class SyllableIterator
implements Iterator<Syllable> {
    private FeatureFileReader features;
    private int fromUnitIndex;
    private int toUnitIndex;
    private final int fiPhone;
    private final byte fvPhone_0;
    private final byte fvPhone_Silence;
    private final int fiSylStart;
    private final int fiSylEnd;
    private final boolean isHalfphone;
    private final int fiLR;
    private final int fvLR_L;
    private final int fvLR_R;
    private int i;
    private Syllable nextSyllable = null;

    public SyllableIterator(FeatureFileReader features, int fromUnitIndex, int toUnitIndex) {
        this.features = features;
        this.fromUnitIndex = fromUnitIndex;
        this.toUnitIndex = toUnitIndex;
        FeatureDefinition featureDefinition = features.getFeatureDefinition();
        this.fiPhone = featureDefinition.getFeatureIndex("phone");
        this.fvPhone_0 = featureDefinition.getFeatureValueAsByte(this.fiPhone, "0");
        this.fvPhone_Silence = featureDefinition.getFeatureValueAsByte(this.fiPhone, "_");
        this.fiSylStart = featureDefinition.getFeatureIndex("segs_from_syl_start");
        this.fiSylEnd = featureDefinition.getFeatureIndex("segs_from_syl_end");
        String halfphoneFeature = "halfphone_lr";
        if (featureDefinition.hasFeature(halfphoneFeature)) {
            this.isHalfphone = true;
            this.fiLR = featureDefinition.getFeatureIndex(halfphoneFeature);
            this.fvLR_L = featureDefinition.getFeatureValueAsByte(this.fiLR, "L");
            this.fvLR_R = featureDefinition.getFeatureValueAsByte(this.fiLR, "R");
        } else {
            this.isHalfphone = false;
            this.fvLR_R = 0;
            this.fvLR_L = 0;
            this.fiLR = 0;
        }
        this.i = fromUnitIndex;
    }

    @Override
    public synchronized boolean hasNext() {
        if (this.nextSyllable == null) {
            this.prepareNextSyllable();
        }
        return this.nextSyllable != null;
    }

    @Override
    public synchronized Syllable next() {
        if (this.nextSyllable == null) {
            this.prepareNextSyllable();
        }
        if (this.nextSyllable == null) {
            throw new NoSuchElementException("no more syllables!");
        }
        Syllable retval = this.nextSyllable;
        this.nextSyllable = null;
        return retval;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("This iterator cannot remove syllables");
    }

    private void prepareNextSyllable() {
        if (this.nextSyllable != null) {
            return;
        }
        if (this.i > this.toUnitIndex) {
            return;
        }
        while (this.i <= this.toUnitIndex && !this.isSyllableStart(this.i)) {
            ++this.i;
        }
        if (this.i > this.toUnitIndex) {
            return;
        }
        int iSyllableStart = this.i;
        while (this.i <= this.toUnitIndex && !this.isSyllableEnd(this.i)) {
            ++this.i;
        }
        if (this.i > this.toUnitIndex) {
            return;
        }
        int iSyllableEnd = this.i;
        this.nextSyllable = new Syllable(this.features, iSyllableStart, iSyllableEnd);
    }

    private boolean isSyllableStart(int index) {
        FeatureVector fv = this.features.getFeatureVector(index);
        return fv.getByteFeature(this.fiPhone) != this.fvPhone_0 && fv.getByteFeature(this.fiPhone) != this.fvPhone_Silence && fv.getByteFeature(this.fiSylStart) == 0 && (!this.isHalfphone || fv.getByteFeature(this.fiLR) == this.fvLR_L);
    }

    private boolean isSyllableEnd(int index) {
        FeatureVector fv = this.features.getFeatureVector(index);
        return fv.getByteFeature(this.fiPhone) != this.fvPhone_0 && fv.getByteFeature(this.fiPhone) != this.fvPhone_Silence && fv.getByteFeature(this.fiSylEnd) == 0 && (!this.isHalfphone || fv.getByteFeature(this.fiLR) == this.fvLR_R);
    }
}

