/*
 * Decompiled with CFR 0.152.
 */
package marytts.util.data.audio;

import java.io.IOException;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import marytts.util.data.BaseDoubleDataSource;

public class AudioDoubleDataSource
extends BaseDoubleDataSource {
    public static final int BYTEBUFFER_LENGTH = 65532;
    protected AudioInputStream ais;
    protected byte[] byteBuf;
    protected int samplingRate;
    protected int bytesPerSample;
    protected boolean bigEndian;
    protected boolean hasMoreData;
    protected boolean bAutomaticClippingControl;
    protected double[] scales;
    protected int scaleInd;

    public AudioDoubleDataSource(AudioInputStream ais, boolean isAutomaticClippingControl) {
        this.ais = ais;
        if (ais.getFormat().getChannels() > 1) {
            throw new IllegalArgumentException("Can only deal with mono signals");
        }
        int bitsPerSample = ais.getFormat().getSampleSizeInBits();
        if (bitsPerSample != 8 && bitsPerSample != 16 && bitsPerSample != 24) {
            throw new IllegalArgumentException("Can deal with sample size 8, 16 or 24, but not " + bitsPerSample);
        }
        this.bytesPerSample = bitsPerSample / 8;
        this.bigEndian = ais.getFormat().isBigEndian();
        this.samplingRate = (int)ais.getFormat().getSampleRate();
        this.byteBuf = new byte[65532];
        this.hasMoreData = true;
        this.scaleInd = -1;
        this.bAutomaticClippingControl = isAutomaticClippingControl;
        if (this.bAutomaticClippingControl) {
            this.scales = new double[20];
            for (int i = 0; i < this.scales.length; ++i) {
                this.scales[i] = 1.0;
            }
        } else {
            this.scales = null;
        }
    }

    public AudioDoubleDataSource(AudioInputStream ais) {
        this(ais, false);
    }

    public int getSamplingRate() {
        return this.samplingRate;
    }

    public AudioFormat getAudioFormat() {
        return this.ais.getFormat();
    }

    @Override
    public int getData(double[] target, int targetPos, int length) {
        int currentPos = targetPos;
        int totalCopied = 0;
        int nTimesRead0 = 0;
        while (this.hasMoreData() && totalCopied < length) {
            int sample;
            byte lobyte;
            int i;
            int nSamplesToCopy = length - totalCopied;
            if (nSamplesToCopy > this.byteBuf.length / this.bytesPerSample) {
                nSamplesToCopy = this.byteBuf.length / this.bytesPerSample;
            }
            int nBytesRead = 0;
            try {
                nBytesRead = this.ais.read(this.byteBuf, 0, this.bytesPerSample * nSamplesToCopy);
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
                return totalCopied;
            }
            if (nBytesRead == -1) {
                this.hasMoreData = false;
                return totalCopied;
            }
            if (nBytesRead == 0) {
                if (++nTimesRead0 <= 10) continue;
                this.hasMoreData = false;
                return totalCopied;
            }
            nTimesRead0 = 0;
            if (this.bytesPerSample == 1) {
                i = 0;
                while (i < nBytesRead) {
                    target[currentPos] = (double)(this.byteBuf[i] << 8) / 128.0;
                    ++i;
                    ++currentPos;
                }
                totalCopied += nBytesRead;
                continue;
            }
            if (this.bytesPerSample == 2) {
                i = 0;
                while (i < nBytesRead) {
                    byte hibyte;
                    if (!this.bigEndian) {
                        lobyte = this.byteBuf[i];
                        hibyte = this.byteBuf[i + 1];
                    } else {
                        lobyte = this.byteBuf[i + 1];
                        hibyte = this.byteBuf[i];
                    }
                    sample = hibyte << 8 | lobyte & 0xFF;
                    target[currentPos] = (double)sample / 32768.0;
                    i += 2;
                    ++currentPos;
                }
                totalCopied += nBytesRead / this.bytesPerSample;
                continue;
            }
            i = 0;
            while (i < nBytesRead) {
                byte hibyte;
                byte midbyte;
                if (!this.bigEndian) {
                    lobyte = this.byteBuf[i];
                    midbyte = this.byteBuf[i + 1];
                    hibyte = this.byteBuf[i + 2];
                } else {
                    lobyte = this.byteBuf[i + 2];
                    midbyte = this.byteBuf[i + 1];
                    hibyte = this.byteBuf[i];
                }
                sample = hibyte << 16 | (midbyte & 0xFF) << 8 | lobyte & 0xFF;
                target[currentPos] = (double)sample / 8388606.0;
                i += 3;
                ++currentPos;
            }
            totalCopied += nBytesRead / this.bytesPerSample;
        }
        assert (totalCopied <= length);
        return totalCopied;
    }

    @Override
    public boolean hasMoreData() {
        return this.hasMoreData;
    }

    @Override
    public int available() {
        try {
            int bytes = this.ais.available();
            return bytes / this.bytesPerSample;
        }
        catch (IOException e) {
            return 0;
        }
    }

    @Override
    public long getDataLength() {
        long frameLength = this.ais.getFrameLength();
        if (frameLength == -1L) {
            return -1L;
        }
        return frameLength;
    }
}

