#include "org_fao_vrmf_core_helpers_singletons_text_jni_CLevenshtein.h"
#define MIN3(a, b, c) ((a) < (b) ? ((a) < (c) ? (a) : (c)) : ((b) < (c) ? (b) : (c)))

JNIEXPORT jint JNICALL Java_org_fao_vrmf_core_helpers_singletons_text_jni_CLevenshtein_lev(JNIEnv *env, jclass obj, jstring string1, jint int1, jstring string2, jint int2) {
    const char *s1 = (*env)->GetStringUTFChars(env, string1, NULL);
    const char *s2 = (*env)->GetStringUTFChars(env, string2, NULL);
    unsigned int s1len, s2len, x, y, lastdiag, olddiag;
    s1len = int1;
    s2len = int2;
    unsigned int column[s1len+1];
    for (y = 1; y <= s1len; y++)
        column[y] = y;
    for (x = 1; x <= s2len; x++) {
        column[0] = x;
        for (y = 1, lastdiag = x-1; y <= s1len; y++) {
            olddiag = column[y];
            column[y] = MIN3(column[y] + 1, column[y-1] + 1, lastdiag + (s1[y-1] == s2[x-1] ? 0 : 1));
            lastdiag = olddiag;
        }
    }
    
    /* See: http://stackoverflow.com/questions/5859673/should-you-call-releasestringutfchars-if-getstringutfchars-returned-a-copy?rq=1 */
    (*env)->ReleaseStringUTFChars(env, string1, s1);
    (*env)->ReleaseStringUTFChars(env, string2, s2);
    
    return(column[s1len]);
}

void main(){}