<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
 	<xsl:output method="xml" indent="yes" encoding="UTF-8"/> 
	<xsl:template match="node()|@*">
		<xsl:copy>
			<xsl:apply-templates select="node()|@*"/>
		</xsl:copy>
	</xsl:template>
	
	<xsl:template match="@score">
		<xsl:attribute name="score">
			<xsl:value-of select="format-number(., '0.0000000000000000')"/>
		</xsl:attribute>
	</xsl:template>
	
	<xsl:template match="//ProcessorsInfo"/>
	<xsl:template match="//vernacularCNames"/>
	<xsl:template match="//kingdomCName"/>
	<xsl:template match="//phylumCName"/>
	<xsl:template match="//classCName"/>
	<xsl:template match="//orderCName"/>
	<xsl:template match="//familyCName"/>
	<xsl:template match="//genusCName"/>
	<xsl:template match="//speciesCName"/>

	<xsl:template match="//normalizedGenusCName"/>
	<xsl:template match="//normalizedSpeciesCName"/>

	<xsl:template match="//scientificCName"/>
	<xsl:template match="//authoritiesCName"/>
	
	<xsl:template match="//simplifiedNameNGram"/>
</xsl:stylesheet>