/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.rest.resourcemanager.is.publisher.is;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.xml.bind.JAXBException;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.gcube.common.resources.gcore.GenericResource;
import org.gcube.common.resources.gcore.Resource;
import org.gcube.common.resources.gcore.ResourceMediator;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.informationsystem.publisher.RegistryPublisherFactory;
import org.gcube.informationsystem.publisher.ScopedPublisher;
import org.gcube.informationsystem.publisher.exception.RegistryNotFoundException;
import org.gcube.resources.discovery.client.api.DiscoveryClient;
import org.gcube.resources.discovery.client.queries.api.Query;
import org.gcube.resources.discovery.client.queries.impl.XQuery;
import org.gcube.resources.discovery.icclient.ICFactory;
import org.gcube.rest.commons.inject.GcubeScope;
import org.gcube.rest.commons.inject.ResourceClass;
import org.gcube.rest.commons.inject.ResourceNamePref;
import org.gcube.rest.commons.resourceawareservice.resources.StatefulResource;
import org.gcube.rest.resourcemanager.publisher.ResourcePublisher;
import org.gcube.rest.resourcemanager.publisher.ResourcePublisherException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

@Singleton
public class PublisherISimpl<T extends StatefulResource>
implements ResourcePublisher<T> {
    private static final Logger logger = LoggerFactory.getLogger(PublisherISimpl.class);
    private String scope;
    private String resourceClass;
    private String resourceNamePref;

    @Inject
    public PublisherISimpl(@Nullable @GcubeScope String scope, @ResourceClass String resourceClass, @ResourceNamePref String resourceNamePref) {
        this.scope = scope;
        this.resourceClass = resourceClass;
        this.resourceNamePref = resourceNamePref;
    }

    public void deleteResource(String resourceID) throws ResourcePublisherException {
        logger.info("deleting resource with ID : " + resourceID + " from IS");
        GenericResource genericResource = PublisherISimpl.getResourceByID(resourceID, this.scope);
        if (genericResource == null) {
            throw new ResourcePublisherException("resource with id : " + resourceID + " not found");
        }
        ScopeProvider.instance.set(this.scope);
        List<String> scopes = Arrays.asList(this.scope);
        ScopedPublisher publish = RegistryPublisherFactory.scopedPublisher();
        Resource r = null;
        try {
            r = publish.remove((Resource)genericResource, scopes);
            logger.info("resource removed with id : " + r.id());
        }
        catch (RegistryNotFoundException e) {
            throw new ResourcePublisherException((Throwable)e);
        }
    }

    public void publishResource(T resource) throws ResourcePublisherException {
        logger.info("creating resource with ID : " + resource.getResourceID() + " from IS");
        GenericResource genericResource = null;
        try {
            genericResource = this.convertToGenericResource(resource, this.resourceClass, this.resourceNamePref);
        }
        catch (IOException | JAXBException | ParserConfigurationException | SAXException e) {
            logger.error("error while converting resource to generic resource", e);
        }
        ScopeProvider.instance.set(this.scope);
        List<String> scopes = Arrays.asList(this.scope);
        ScopedPublisher publish = RegistryPublisherFactory.scopedPublisher();
        Resource r = null;
        try {
            r = publish.create((Resource)genericResource, scopes);
            logger.info("resource created with id : " + r.id());
        }
        catch (RegistryNotFoundException e) {
            throw new ResourcePublisherException((Throwable)e);
        }
    }

    public void updateResource(T resource) throws ResourcePublisherException {
        logger.info("updating resource with ID : " + resource.getResourceID() + " to IS");
        ScopeProvider.instance.set(this.scope);
        ScopedPublisher publish = RegistryPublisherFactory.scopedPublisher();
        GenericResource genericResource = null;
        try {
            genericResource = this.convertToGenericResource(resource, this.resourceClass, this.resourceNamePref);
        }
        catch (IOException | JAXBException | ParserConfigurationException | SAXException e) {
            logger.error("error while converting resource to generic resource", e);
        }
        Resource r = null;
        try {
            r = publish.update((Resource)genericResource);
            logger.info("resource updated with id : " + r.id());
        }
        catch (RegistryNotFoundException e) {
            throw new ResourcePublisherException((Throwable)e);
        }
    }

    private static GenericResource getResourceByID(String resourceID, String scope) {
        ScopeProvider.instance.set(scope);
        XQuery query = ICFactory.queryFor(GenericResource.class);
        query.addCondition("$resource/ID/text() eq '" + resourceID + "'");
        DiscoveryClient client = ICFactory.clientFor(GenericResource.class);
        List resources = client.submit((Query)query);
        if (resources.size() > 0) {
            return (GenericResource)resources.get(0);
        }
        logger.warn("Could not find resource with ID : " + resourceID);
        return null;
    }

    private GenericResource convertToGenericResource(T resource, String clazz, String name) throws SAXException, IOException, ParserConfigurationException, JAXBException {
        GenericResource genericResource = new GenericResource();
        ResourceMediator.setId((Resource)genericResource, (String)resource.getResourceID());
        genericResource.newProfile();
        genericResource.profile().name(name + "." + resource.getResourceID());
        genericResource.profile().type(clazz);
        String serialization = resource.toXML();
        logger.info("resource serialization : " + serialization);
        Element newBody = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(new ByteArrayInputStream(serialization.getBytes())).getDocumentElement();
        genericResource.profile().newBody();
        Node importedNode = genericResource.profile().body().getOwnerDocument().importNode(newBody, true);
        genericResource.profile().body().appendChild(importedNode);
        return genericResource;
    }
}

