package org.gcube.rest.resourcemanager.is.discovery;

import java.util.List;
import java.util.Set;

import javax.inject.Singleton;

import org.gcube.rest.commons.resourceawareservice.resources.HostNode;
import org.gcube.rest.commons.resourceawareservice.resources.Resource;
import org.gcube.rest.commons.resourceawareservice.resources.RunInstance;
import org.gcube.rest.commons.resourceawareservice.resources.SerInstance;
import org.gcube.rest.resourcemanager.discovery.InformationCollector;

@Singleton
public class ISInformationCollector implements InformationCollector {
	@Override
	public List<Resource> getGenericResourcesByID(String id, String scope) {
		return ISHelper.getGenericResourcesByID(id, scope);
	}

	@Override
	public List<Resource> getGenericResourcesByName(String name, String scope) {
		return ISHelper.getGenericResourcesByName(name, scope);
	}

	@Override
	public List<Resource> getGenericResourcesByType(String type, String scope) {
		return ISHelper.getGenericResourcesByType(type, scope);
	}

	@Override
	public List<Resource> getGenericResourcesByTypeAndName(String type, String name, String scope) {
		return ISHelper.getGenericResourcesByTypeAndName(type, name, scope);
	}

	@Override
	public List<String> listGenericResourceIDsByType(String type, String scope) {
		return ISHelper.listGenericResourceIDsByType(type, scope);
	}

	@Override
	public Set<RunInstance> discoverRunningInstancesFilteredByEndopointKey(String serviceName, String serviceClass, String endpointKey, String scope) {
		return ISHelper.discoverRunningInstancesFilteredByEndopointKey(serviceName, serviceClass, endpointKey, scope);
	}

	@Override
	public Set<RunInstance> discoverRunningInstances(String serviceName, String serviceClass, String scope) {
		return ISHelper.discoverRunningInstances(serviceName, serviceClass, scope);
	}

	@Override
	public List<SerInstance> discoverServiceInstances(String serviceName, String serviceClass, String scope) {
		return ISHelper.discoverServiceInstances(serviceName, serviceClass, scope);
	}

	@Override
	public List<HostNode> discoverHostingNodes(String scope) {
		return ISHelper.discoverHostingNodes(scope);
	}

	public static void main(String[] args) {

		String scope = "/gcube/devNext";

		String id = "14b8b6c0-5f23-11e2-8e13-bdef13ce362e";
		String name = "GnuplotWrapperTP";
		String type = "DTSTransformationProgram";
		String serviceName = "ExecutionEngineService";
		String serviceClass = "Execution";
		String entrykeyName = "resteasy-servlet";
		
		
		Object result;
//		result = new ISInformationCollector().getGenericResourcesByID(id, scope);
//		result = new ISInformationCollector().getGenericResourcesByName(name, scope);
//		result = new ISInformationCollector().getGenericResourcesByType("VRE", scope);
//		result = new ISInformationCollector().listGenericResourceIDsByType(type, scope);
//		result = new ISInformationCollector().discoverRunningInstances(serviceName, serviceClass, entrykeyName, scope);
		result = new ISInformationCollector().discoverHostingNodes(scope);
		
		if (result instanceof List) {
			if (((List) result).get(0) instanceof String) {
				List<String> res = (List<String>) result;
				for (String asd : res) {
					System.out.println(asd);
				}
			} else if (((List) result).get(0) instanceof Resource) {
					List<Resource> res = (List<Resource>) result;
					for (Resource asd : res) {
						System.out.println(asd);
					}
			} else if (((List) result).get(0) instanceof HostNode) {
				List<HostNode> hns = (List<HostNode>) result;
				for (HostNode asd : hns) {
					System.out.println(asd.evaluate("/Profile/Infrastructure/text()"));
					System.out.println(asd.evaluate("/Profile/Site/Country/text()"));
					System.out.println(asd.evaluate("/Profile/Site/Domain/text()"));
					System.out.println(asd.evaluate("/Profile/Site/Latitude/text()"));
					System.out.println(asd.evaluate("/Profile/Site/Longitude/text()"));
					System.out.println(asd.evaluate("/Profile/Site/Location/text()"));

					System.out.println(asd.evaluate("/Profile/GHNDescription/Architecture/@PlatformType"));
					System.out.println();
				}
			}
		}else if (result instanceof Set) {
			Set<String> res = (Set<String>) result;
			for (String asd : res) {
				System.out.println(asd);
			}
		}
	}

}
