/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.rest.resourcemanager.is.discovery;

import com.google.common.collect.Lists;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.xml.bind.JAXBException;
import javax.xml.parsers.ParserConfigurationException;
import org.gcube.common.resources.gcore.GCoreEndpoint;
import org.gcube.common.resources.gcore.GenericResource;
import org.gcube.common.resources.gcore.HostingNode;
import org.gcube.common.resources.gcore.ServiceInstance;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.resources.discovery.client.api.DiscoveryClient;
import org.gcube.resources.discovery.client.api.ResultParser;
import org.gcube.resources.discovery.client.queries.api.Query;
import org.gcube.resources.discovery.client.queries.api.SimpleQuery;
import org.gcube.resources.discovery.client.queries.impl.XQuery;
import org.gcube.resources.discovery.icclient.ICFactory;
import org.gcube.rest.commons.helpers.XMLConverter;
import org.gcube.rest.commons.resourceawareservice.resources.HostNode;
import org.gcube.rest.commons.resourceawareservice.resources.Resource;
import org.gcube.rest.commons.resourceawareservice.resources.RunInstance;
import org.gcube.rest.commons.resourceawareservice.resources.SerInstance;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Node;

public class ISHelper<T> {
    private static final Logger logger = LoggerFactory.getLogger(ISHelper.class);
    private DiscoveryClient<T> client;
    private SimpleQuery query;

    private ISHelper(DiscoveryClient<T> client, SimpleQuery query) {
        this.client = client;
        this.query = query;
    }

    public List<T> submit() {
        return this.client.submit((Query)this.query);
    }

    public static List<Resource> getGenericResourcesByID(String id, String scope) {
        ISHelper<GenericResource> ic = new ISInformationCollectorBuilder<GenericResource>(GenericResource.class, GenericResource.class, scope).addCondition("$resource/ID/text() eq '" + id + "'").build();
        List<GenericResource> result = ic.submit();
        ArrayList<Resource> resources = new ArrayList<Resource>();
        for (GenericResource gr : result) {
            Resource res = new Resource();
            res.setResourceID(gr.id());
            if (gr.scopes() != null && gr.scopes().asCollection() != null) {
                res.setScopes((List)Lists.newArrayList((Iterable)gr.scopes().asCollection()));
            }
            res.setName(gr.profile().name());
            res.setDescription(gr.profile().description());
            res.setBody((Node)gr.profile().body());
            resources.add(res);
        }
        return resources;
    }

    public static List<Resource> getGenericResourcesByName(String name, String scope) {
        ISHelper<GenericResource> ic = new ISInformationCollectorBuilder<GenericResource>(GenericResource.class, GenericResource.class, scope).addCondition("$resource/Profile/Name/text() eq '" + name + "'").build();
        List<GenericResource> result = ic.submit();
        ArrayList<Resource> resources = new ArrayList<Resource>();
        for (GenericResource gr : result) {
            resources.add(ISHelper.fromGenericResource(gr));
        }
        return resources;
    }

    public static List<Resource> getGenericResourcesByType(String type, String scope) {
        ISHelper<GenericResource> ic = new ISInformationCollectorBuilder<GenericResource>(GenericResource.class, GenericResource.class, scope).addCondition("$resource/Profile/SecondaryType/text() eq '" + type + "'").build();
        List<GenericResource> result = ic.submit();
        ArrayList<Resource> resources = new ArrayList<Resource>();
        for (GenericResource gr : result) {
            resources.add(ISHelper.fromGenericResource(gr));
        }
        return resources;
    }

    public static List<Resource> getGenericResourcesByTypeAndName(String type, String name, String scope) {
        ISHelper<GenericResource> ic = new ISInformationCollectorBuilder<GenericResource>(GenericResource.class, GenericResource.class, scope).addCondition("$resource/Profile/SecondaryType/text() eq '" + type + "'").addCondition("$resource/Profile/Name/text() eq '" + name + "'").build();
        List<GenericResource> result = ic.submit();
        ArrayList<Resource> resources = new ArrayList<Resource>();
        for (GenericResource gr : result) {
            resources.add(ISHelper.fromGenericResource(gr));
        }
        return resources;
    }

    private static Resource fromGenericResource(GenericResource gr) {
        Resource res = new Resource();
        res.setResourceID(gr.id());
        res.setName(gr.profile().name());
        res.setType(gr.profile().type());
        if (gr.scopes() != null && gr.scopes().size() > 0) {
            res.setScopes(new ArrayList(gr.scopes().asCollection()));
        }
        res.setDescription(gr.profile().description());
        res.setBody((Node)gr.profile().body());
        return res;
    }

    public static List<String> listGenericResourceIDsByType(String type, String scope) {
        ISHelper<String> ic = new ISInformationCollectorBuilder<String>(GenericResource.class, String.class, scope).addCondition("$resource/Profile/SecondaryType/text() eq '" + type + "'").setResult("$resource/ID/text()").build();
        List<String> result = ic.submit();
        return result;
    }

    public static Set<RunInstance> discoverRunningInstances(String serviceName, String serviceClass, String scope) {
        ISHelper<GCoreEndpoint> ic = new ISInformationCollectorBuilder<GCoreEndpoint>(GCoreEndpoint.class, GCoreEndpoint.class, scope).addCondition("$resource/Profile/ServiceClass/text() eq '" + serviceClass + "'").addCondition("$resource/Profile/ServiceName/text() eq '" + serviceName + "'").build();
        List<GCoreEndpoint> result = ic.submit();
        HashSet<RunInstance> endpoints = new HashSet<RunInstance>();
        for (GCoreEndpoint se : result) {
            if (se == null || se.profile() == null || se.profile().endpointMap() == null) continue;
            String status = se.profile().deploymentData().status();
            if (!status.equalsIgnoreCase("ready")) {
                logger.debug("running instance : " + se.id() + " is NOT ready");
                continue;
            }
            try {
                endpoints.add(new RunInstance(se.id(), new HashSet(se.scopes().asCollection()), (RunInstance.Profile)XMLConverter.fromXML((String)XMLConverter.convertToXML((Object)se.profile()), RunInstance.Profile.class)));
            }
            catch (JAXBException e) {
                logger.warn("unable to parse running instance", (Throwable)e);
            }
        }
        logger.info("endpoints found in discovering: " + endpoints);
        return endpoints;
    }

    public static Set<RunInstance> discoverRunningInstancesFilteredByEndopointKey(String serviceName, String serviceClass, String endpointKey, String scope) {
        logger.info("discovering RI for : " + serviceName + " " + serviceClass + " " + scope);
        Set<RunInstance> set = ISHelper.discoverRunningInstances(serviceName, serviceClass, scope);
        logger.info("RIs : " + set);
        Iterator<RunInstance> setIterator = set.iterator();
        while (setIterator.hasNext()) {
            RunInstance currentElement = setIterator.next();
            if (!currentElement.getProfile().accessPoint.runningInstanceInterfaces.containsKey(endpointKey)) {
                setIterator.remove();
                continue;
            }
            URI uri = (URI)currentElement.getProfile().accessPoint.runningInstanceInterfaces.get(endpointKey);
            currentElement.getProfile().accessPoint.runningInstanceInterfaces = new HashMap();
            currentElement.getProfile().accessPoint.runningInstanceInterfaces.put(endpointKey, uri);
        }
        logger.info("endpoints found in discovering: " + set);
        return set;
    }

    public static List<SerInstance> discoverServiceInstances(String serviceName, String serviceClass, String scope) {
        ISHelper<ServiceInstance> ic = new ISInformationCollectorBuilder<ServiceInstance>(ServiceInstance.class, ServiceInstance.class, scope).addCondition("$resource/Data/gcube:ServiceClass/text() eq '" + serviceClass + "'").addCondition("$resource/Data/gcube:ServiceName/text() eq '" + serviceName + "'").build();
        List<ServiceInstance> result = ic.submit();
        ArrayList<SerInstance> serviceInstances = new ArrayList<SerInstance>();
        for (ServiceInstance si : result) {
            serviceInstances.add(new SerInstance(si.endpoint(), si.key(), serviceName, serviceClass, new SerInstance.NodeProperties(si.properties().nodeId(), new ArrayList(si.properties().scopes()), (Node)si.properties().customProperties())));
        }
        logger.info("service instances found: " + serviceInstances);
        return serviceInstances;
    }

    public static List<HostNode> discoverHostingNodes(String scope) {
        ISHelper<HostingNode> ic = new ISInformationCollectorBuilder<HostingNode>(HostingNode.class, HostingNode.class, scope).build();
        List<HostingNode> result = ic.submit();
        ArrayList<HostNode> hostingNodes = new ArrayList<HostNode>();
        for (HostingNode hn : result) {
            try {
                Node profile = XMLConverter.convertToXMLNode((Object)hn.profile());
                HostNode hostnode = new HostNode(hn.id(), new ArrayList(hn.scopes().asCollection()), (HostNode.Profile)XMLConverter.fromXML((Node)profile, HostNode.Profile.class));
                hostingNodes.add(hostnode);
            }
            catch (JAXBException | ParserConfigurationException e) {
                logger.error("XML object marshal failed", e);
                return null;
            }
        }
        logger.info("hosting nodes found: " + hostingNodes);
        return hostingNodes;
    }

    public static class ISInformationCollectorBuilder<T> {
        private final Class<?> clientFor;
        private final Class<T> returnType;
        private final String scope;
        private String conditions;
        private String result;

        public ISInformationCollectorBuilder(Class<?> clientFor, Class<T> returnType, String scope) {
            this.clientFor = clientFor;
            this.returnType = returnType;
            this.scope = scope;
        }

        public ISInformationCollectorBuilder<T> addCondition(String condition) {
            condition = "(" + condition + ")";
            this.conditions = this.conditions != null ? this.conditions + " and " + condition : condition;
            return this;
        }

        public ISInformationCollectorBuilder<T> setResult(String expression) {
            this.result = expression;
            return this;
        }

        public ISHelper<T> build() {
            logger.info("Building Information Collector for IS under scope: " + this.scope + (this.conditions != null ? " with conditions: " + this.conditions : "") + (this.result != null ? " and result: " + this.result : ""));
            ScopeProvider.instance.set(this.scope);
            XQuery query = ICFactory.queryFor(this.clientFor);
            if (this.conditions != null) {
                query.addCondition(this.conditions);
            }
            if (this.result != null) {
                query.setResult(this.result);
            }
            DiscoveryClient client = this.returnType.equals(String.class) ? ICFactory.clientWith((ResultParser)new ResultParser<T>(){

                public T parse(String result) throws Exception {
                    return result;
                }
            }) : ICFactory.clientFor(this.returnType);
            return new ISHelper(client, (SimpleQuery)query);
        }
    }
}

