/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.rest.commons.db.model.core;

import com.google.inject.persist.Transactional;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import org.gcube.rest.commons.db.dao.core.BaseRecord;
import org.gcube.rest.commons.db.model.core.IGenericDAO;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Example;
import org.hibernate.criterion.Projections;

public abstract class GenericDaoImpl<T extends BaseRecord>
implements IGenericDAO<T> {
    @Inject
    private EntityManager em;

    void setEntityManager(EntityManager em) {
        this.em = em;
    }

    public abstract Class<T> getClazz();

    @Override
    @Transactional
    public T load(Long id) {
        return (T)((BaseRecord)this.em.find(this.getClazz(), (Object)id));
    }

    @Override
    @Transactional
    public T save(T object) {
        BaseRecord savedEntity = (BaseRecord)this.em.merge(object);
        return (T)savedEntity;
    }

    @Override
    public void delete(T object) {
        this.deleteById(((BaseRecord)object).getId());
    }

    @Override
    @Transactional
    public void deleteById(Long id) {
        this.em.remove(this.load(id));
    }

    @Override
    public List<T> findAll() {
        return this.findByCriteria(new Criterion[0]);
    }

    @Override
    public int countAll() {
        return this.countByCriteria(new Criterion[0]);
    }

    protected int countByCriteria(Criterion ... criterion) {
        Session session = (Session)this.em.getDelegate();
        Criteria crit = session.createCriteria(this.getClazz());
        crit.setProjection(Projections.rowCount());
        for (Criterion c : criterion) {
            crit.add(c);
        }
        return (Integer)crit.list().get(0);
    }

    public int countByExample(T exampleInstance) {
        Session session = (Session)this.em.getDelegate();
        Criteria crit = session.createCriteria(this.getClazz());
        crit.setProjection(Projections.rowCount());
        crit.add((Criterion)Example.create(exampleInstance));
        return (Integer)crit.list().get(0);
    }

    @Override
    public List<T> findByExample(T exampleInstance) {
        Session session = (Session)this.em.getDelegate();
        Criteria crit = session.createCriteria(this.getClazz());
        List result = crit.list();
        return result;
    }

    @Override
    public List<T> findByNamedQuery(String name, Object ... params) {
        Query query = this.em.createNamedQuery(name);
        for (int i = 0; i < params.length; ++i) {
            query.setParameter(i + 1, params[i]);
        }
        List result = query.getResultList();
        return result;
    }

    @Override
    public List<T> findByNamedQueryAndNamedParams(String name, Map<String, ? extends Object> params) {
        Query query = this.em.createNamedQuery(name);
        for (Map.Entry<String, ? extends Object> param : params.entrySet()) {
            query.setParameter(param.getKey(), param.getValue());
        }
        List result = query.getResultList();
        return result;
    }

    @Override
    public List<T> findByCriteria(Criterion ... criterion) {
        return this.findByCriteria(null, -1, -1, criterion);
    }

    public List<T> findByCriteria(Map<String, String> aliases, Criterion ... criterion) {
        return this.findByCriteria(aliases, -1, -1, criterion);
    }

    protected List<T> findByCriteria(Map<String, String> aliases, int firstResult, int maxResults, Criterion ... criterion) {
        Session session = (Session)this.em.getDelegate();
        Criteria crit = session.createCriteria(this.getClazz());
        if (aliases != null) {
            for (Map.Entry<String, String> alias : aliases.entrySet()) {
                crit.createAlias(alias.getKey(), alias.getValue());
            }
        }
        for (Criterion c : criterion) {
            crit.add(c);
        }
        if (firstResult > 0) {
            crit.setFirstResult(firstResult);
        }
        if (maxResults > 0) {
            crit.setMaxResults(maxResults);
        }
        List result = crit.list();
        return result;
    }

    public T findById(Long id) {
        BaseRecord result = (BaseRecord)this.em.find(this.getClazz(), (Object)id);
        return (T)result;
    }
}

