/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.rest.resourcemanager.discoverer;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.gcube.rest.commons.inject.ResourceClass;
import org.gcube.rest.commons.resourceawareservice.resources.StatefulResource;
import org.gcube.rest.resourcemanager.discoverer.DiscovererAPI;
import org.gcube.rest.resourcemanager.discoverer.exceptions.DiscovererException;
import org.gcube.rest.resourcemanager.discoverer.ri.RunningInstancesDiscoverer;
import org.gcube.rest.resourcemanager.harvester.IResourceHarvester;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class Discoverer<T extends StatefulResource>
implements DiscovererAPI<T> {
    private static final Logger logger = LoggerFactory.getLogger(Discoverer.class);
    private final RunningInstancesDiscoverer riDiscoverer;
    private final IResourceHarvester<T> harvester;
    private final Class<T> clazz;

    @Inject
    public Discoverer(RunningInstancesDiscoverer riDiscoverer, IResourceHarvester<T> harvester, @ResourceClass Class<T> clazz) {
        this.riDiscoverer = riDiscoverer;
        this.harvester = harvester;
        this.clazz = clazz;
    }

    @Override
    public Set<String> discoverRunningInstances() {
        Set<String> ris = this.riDiscoverer.discoverRunningInstances();
        logger.info("Running Instances Found : " + ris);
        return ris;
    }

    @Override
    public Map<String, Set<T>> discoverResources(Set<String> endpoints) throws DiscovererException {
        if (endpoints == null || endpoints.size() == 0) {
            logger.warn("No endpoints were given");
            return null;
        }
        logger.info("discovering resourceIDs at endpoints : " + endpoints);
        HashMap<String, Set<T>> foundResources = new HashMap<String, Set<T>>();
        for (String endpoint : endpoints) {
            if (endpoint.endsWith("/")) {
                endpoint = endpoint.substring(0, endpoint.length() - 1);
            }
            try {
                logger.info("calling harvester...");
                Set<T> resources = this.harvester.getResources(endpoint, this.clazz);
                logger.info("calling harvester...OK");
                foundResources.put(endpoint, resources);
            }
            catch (Exception e) {
                logger.warn("No resources found for endpoint : " + endpoint + " will skip this endpoint", (Throwable)e);
            }
        }
        return foundResources;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Map<String, Set<String>> discoverResourceIDs(Set<String> endpoints) throws DiscovererException {
        if (endpoints == null || endpoints.size() == 0) {
            logger.warn("No endpoints were given.");
            return null;
        }
        logger.info("discovering resourceIDs at endpoints : " + endpoints);
        HashMap<void, Set<T>> foundResources = new HashMap<void, Set<T>>();
        HashMap<String, Set<String>> serviceResources = new HashMap<String, Set<String>>();
        for (String string : endpoints) {
            void var5_5;
            if (string.endsWith("/")) {
                String string2 = string.substring(0, string.length() - 1);
            }
            try {
                logger.info("calling harvester...");
                Set<T> resources = this.harvester.getResources((String)var5_5, this.clazz);
                logger.info("calling harvester...OK");
                foundResources.put(var5_5, resources);
            }
            catch (Exception e) {
                logger.warn("No resources found for endpoint : " + (String)var5_5 + " will skip endpoint", (Throwable)e);
            }
        }
        for (Map.Entry entry : foundResources.entrySet()) {
            String endpoint = (String)entry.getKey();
            Set resources = (Set)entry.getValue();
            for (StatefulResource resource : resources) {
                if (!serviceResources.containsKey(endpoint)) {
                    serviceResources.put(endpoint, new HashSet());
                }
                ((Set)serviceResources.get(endpoint)).add(resource.getResourceID());
            }
        }
        return serviceResources;
    }
}

