/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.software.processor;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.gcube.common.software.model.GlobalConfig;
import org.gcube.common.software.model.ProcessorConfig;
import org.gcube.common.software.model.SoftwareArtifactMetadata;
import org.gcube.common.software.processor.biblatex.BibLaTeXExporter;
import org.gcube.common.software.processor.zenodo.ZenodoExporter;

public abstract class SoftwareArtifactProcessor {
    protected static Map<String, Class<? extends SoftwareArtifactProcessor>> availableProcessors = new HashMap<String, Class<? extends SoftwareArtifactProcessor>>();
    protected File outputDirectory;
    protected GlobalConfig globalConfig;
    protected SoftwareArtifactMetadata softwareArtifactMetadata;
    protected ProcessorConfig processorConfig;
    protected boolean first;
    protected boolean last;
    protected final String exportFileNameExtension;

    private static void add(Class<? extends SoftwareArtifactProcessor> clz) {
        availableProcessors.put(clz.getSimpleName(), clz);
    }

    public static Map<String, Class<? extends SoftwareArtifactProcessor>> getAvailableProcessors() {
        return availableProcessors;
    }

    protected SoftwareArtifactProcessor(String exportFileNameExtension) {
        this.exportFileNameExtension = exportFileNameExtension;
    }

    public void setOutputDirectory(File outputDirectory) {
        this.outputDirectory = outputDirectory;
    }

    public GlobalConfig getGlobalConfig() {
        return this.globalConfig;
    }

    public void setGlobalConfig(GlobalConfig globalConfig) {
        this.globalConfig = globalConfig;
    }

    public SoftwareArtifactMetadata getSoftwareArtifactConfig() {
        return this.softwareArtifactMetadata;
    }

    public void setSoftwareArtifactConfig(SoftwareArtifactMetadata softwareArtifactMetadata) {
        this.softwareArtifactMetadata = softwareArtifactMetadata;
    }

    public ProcessorConfig getExporterConfig() {
        return this.processorConfig;
    }

    public void setExporterConfig(ProcessorConfig processorConfig) {
        this.processorConfig = processorConfig;
    }

    public void setFirst(boolean first) {
        this.first = first;
    }

    public void setLast(boolean last) {
        this.last = last;
    }

    public abstract void export() throws Exception;

    public File getOutputFile() throws Exception {
        String fileName = this.globalConfig.getFileName() + this.exportFileNameExtension;
        File file = new File(this.outputDirectory, fileName);
        return file;
    }

    static {
        SoftwareArtifactProcessor.add(ZenodoExporter.class);
        SoftwareArtifactProcessor.add(BibLaTeXExporter.class);
    }
}

