/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.storagehub.client.proxies;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.net.URLEncoder;
import java.util.List;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.client.WebTarget;
import org.gcube.common.clients.Call;
import org.gcube.common.clients.delegates.ProxyDelegate;
import org.gcube.common.storagehub.client.proxies.WorkspaceManagerClient;
import org.gcube.common.storagehub.model.expressions.OrderField;
import org.gcube.common.storagehub.model.expressions.SearchableItem;
import org.gcube.common.storagehub.model.items.Item;
import org.gcube.common.storagehub.model.query.Query;
import org.gcube.common.storagehub.model.service.ItemList;
import org.gcube.common.storagehub.model.service.ItemWrapper;

public class DefaultWorkspaceManager
implements WorkspaceManagerClient {
    private final ProxyDelegate<WebTarget> delegate;

    public DefaultWorkspaceManager(ProxyDelegate<WebTarget> config) {
        this.delegate = config;
    }

    @Override
    public <T extends Item> T getWorkspace(final String ... excludeNodes) {
        Call call = new Call<WebTarget, ItemWrapper<T>>(){

            public ItemWrapper<T> call(WebTarget manager) throws Exception {
                WebTarget myManager = manager;
                if (excludeNodes != null && excludeNodes.length > 0) {
                    myManager = myManager.queryParam("exclude", (Object[])excludeNodes);
                }
                Invocation.Builder builder = myManager.request(new String[]{"application/json"});
                ItemWrapper response = (ItemWrapper)builder.get(ItemWrapper.class);
                return response;
            }
        };
        try {
            ItemWrapper result = (ItemWrapper)this.delegate.make(call);
            return (T)result.getItem();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public <T extends Item> T retieveItemByPath(final String relativePath, final String ... excludeNodes) {
        Call call = new Call<WebTarget, ItemWrapper<T>>(){

            public ItemWrapper<T> call(WebTarget manager) throws Exception {
                WebTarget myManager = manager;
                if (excludeNodes != null && excludeNodes.length > 0) {
                    myManager = myManager.queryParam("exclude", (Object[])excludeNodes);
                }
                myManager = manager.queryParam("relPath", new Object[]{relativePath});
                Invocation.Builder builder = myManager.request(new String[]{"application/json"});
                ItemWrapper response = (ItemWrapper)builder.get(ItemWrapper.class);
                return response;
            }
        };
        try {
            ItemWrapper result = (ItemWrapper)this.delegate.make(call);
            return (T)result.getItem();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public List<? extends Item> getVreFolders(final String ... excludeNodes) {
        Call<WebTarget, ItemList> call = new Call<WebTarget, ItemList>(){

            public ItemList call(WebTarget manager) throws Exception {
                WebTarget myManager = manager.path("vrefolders");
                if (excludeNodes != null && excludeNodes.length > 0) {
                    myManager = myManager.queryParam("exclude", (Object[])excludeNodes);
                }
                Invocation.Builder builder = myManager.request(new String[]{"application/json"});
                ItemList response = (ItemList)builder.get(ItemList.class);
                return response;
            }
        };
        try {
            ItemList result = (ItemList)this.delegate.make((Call)call);
            return result.getItemlist();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public List<? extends Item> getVreFolders(final int start, final int limit, final String ... excludeNodes) {
        Call<WebTarget, ItemList> call = new Call<WebTarget, ItemList>(){

            public ItemList call(WebTarget manager) throws Exception {
                WebTarget myManager = manager.path("vrefolders");
                if (excludeNodes != null && excludeNodes.length > 0) {
                    myManager = myManager.queryParam("exclude", (Object[])excludeNodes);
                }
                myManager = myManager.queryParam("start", new Object[]{start}).queryParam("limit", new Object[]{limit});
                Invocation.Builder builder = myManager.request(new String[]{"application/json"});
                ItemList response = (ItemList)builder.get(ItemList.class);
                return response;
            }
        };
        try {
            ItemList result = (ItemList)this.delegate.make((Call)call);
            return result.getItemlist();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public <T extends Item> T getVreFolder(final String ... excludeNodes) {
        Call call = new Call<WebTarget, ItemWrapper<T>>(){

            public ItemWrapper<T> call(WebTarget manager) throws Exception {
                WebTarget myManager = manager.path("vrefolder");
                if (excludeNodes != null && excludeNodes.length > 0) {
                    myManager = myManager.queryParam("exclude", (Object[])excludeNodes);
                }
                Invocation.Builder builder = myManager.request(new String[]{"application/json"});
                ItemWrapper response = (ItemWrapper)builder.get(ItemWrapper.class);
                return response;
            }
        };
        try {
            ItemWrapper result = (ItemWrapper)this.delegate.make(call);
            return (T)result.getItem();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public List<? extends Item> getRecentModifiedFilePerVre() {
        Call<WebTarget, ItemList> call = new Call<WebTarget, ItemList>(){

            public ItemList call(WebTarget manager) throws Exception {
                WebTarget myManager = manager.path("vrefolder").path("recents");
                Invocation.Builder builder = myManager.request(new String[]{"application/json"});
                ItemList response = (ItemList)builder.get(ItemList.class);
                return response;
            }
        };
        try {
            ItemList result = (ItemList)this.delegate.make((Call)call);
            return result.getItemlist();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public <T extends Item> T getTrashFolder(final String ... excludeNodes) {
        Call call = new Call<WebTarget, ItemWrapper<T>>(){

            public ItemWrapper<T> call(WebTarget manager) throws Exception {
                WebTarget myManager = manager.path("trash");
                if (excludeNodes != null && excludeNodes.length > 0) {
                    myManager = myManager.queryParam("exclude", (Object[])excludeNodes);
                }
                Invocation.Builder builder = myManager.request(new String[]{"application/json"});
                ItemWrapper response = (ItemWrapper)builder.get(ItemWrapper.class);
                return response;
            }
        };
        try {
            ItemWrapper result = (ItemWrapper)this.delegate.make(call);
            return (T)result.getItem();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public List<? extends Item> search(final Query<SearchableItem<?>> query, final String ... excludeNodes) {
        Call<WebTarget, ItemList> call = new Call<WebTarget, ItemList>(){

            public ItemList call(WebTarget manager) throws Exception {
                WebTarget myManager = manager.path("query");
                if (excludeNodes != null && excludeNodes.length > 0) {
                    myManager = myManager.queryParam("exclude", (Object[])excludeNodes);
                }
                if (query.getOrderFields() != null && query.getOrderFields().size() > 0) {
                    for (OrderField field : query.getOrderFields()) {
                        myManager = myManager.queryParam("o", new Object[]{"[" + field.getField().getName() + "] " + field.getMode().toString()});
                    }
                }
                myManager = myManager.queryParam("n", new Object[]{query.getSearchableItem().getNodeValue()});
                if (query.getLimit() != -1) {
                    myManager = myManager.queryParam("l", new Object[]{query.getLimit()});
                }
                if (query.getOffset() != -1) {
                    myManager = myManager.queryParam("f", new Object[]{query.getOffset()});
                }
                ObjectMapper mapper = new ObjectMapper();
                String serializedJson = mapper.writeValueAsString((Object)query.getExpression());
                myManager = myManager.queryParam("e", new Object[]{URLEncoder.encode(serializedJson)});
                Invocation.Builder builder = myManager.request(new String[]{"application/json"});
                ItemList response = (ItemList)builder.get(ItemList.class);
                return response;
            }
        };
        try {
            ItemList result = (ItemList)this.delegate.make((Call)call);
            return result.getItemlist();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

