package org.gcube.common.storagehub.client.dsl;

import org.gcube.common.storagehub.client.StreamDescriptor;
import org.gcube.common.storagehub.client.proxies.ItemManagerClient;
import org.gcube.common.storagehub.model.items.Item;

public abstract class ItemContainer<I extends Item> {
	
	protected ItemManagerClient itemclient;
	
	protected String itemId = null;
	protected I item;
	
	protected ItemContainer(ItemManagerClient itemclient, I item) {
		this.itemclient = itemclient;
	}
	
	protected ItemContainer(ItemManagerClient itemclient, String itemId) {
		this.itemclient = itemclient;
	}
	
	protected void setItem(I item) {
		this.item = item;
		this.itemId = item.getId();
	}
	
	public StreamDescriptor download() {
		return itemclient.download(this.itemId);
	}
		
}
