/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.storagehub.client.dsl;

import org.gcube.common.storagehub.client.StreamDescriptor;
import org.gcube.common.storagehub.client.dsl.ContainerType;
import org.gcube.common.storagehub.client.dsl.FolderContainer;
import org.gcube.common.storagehub.client.dsl.ListResolver;
import org.gcube.common.storagehub.client.proxies.ItemManagerClient;
import org.gcube.common.storagehub.model.Metadata;
import org.gcube.common.storagehub.model.exceptions.StorageHubException;
import org.gcube.common.storagehub.model.items.FolderItem;
import org.gcube.common.storagehub.model.items.Item;

public abstract class ItemContainer<I extends Item> {
    protected ItemManagerClient itemclient;
    protected String itemId = null;
    protected I item;
    boolean invalidated = false;

    protected ItemContainer(ItemManagerClient itemclient, I item) {
        this.itemclient = itemclient;
        this.item = item;
        this.itemId = item.getId();
    }

    protected ItemContainer(ItemManagerClient itemclient, String itemId) {
        this.itemclient = itemclient;
        this.itemId = itemId;
    }

    protected void setItem(I item) {
        this.item = item;
        this.itemId = item.getId();
    }

    public String getId() {
        return this.itemId;
    }

    public abstract ContainerType getType();

    public I get() {
        if (this.item == null || this.invalidated) {
            try {
                Item toRet = this.itemclient.get(this.itemId, new String[0]);
                this.invalidated = false;
                this.item = toRet;
                return (I)toRet;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return this.item;
    }

    protected void invalidateItem() {
        this.invalidated = true;
    }

    public StreamDescriptor download(String ... nodeIdsToExclude) throws StorageHubException {
        return this.itemclient.download(this.itemId, nodeIdsToExclude);
    }

    public ListResolver getAnchestors() throws StorageHubException {
        return new ListResolver((onlyType, includeHidden, excludes) -> this.itemclient.getAnchestors(this.itemId, excludes), this.itemclient);
    }

    public void delete() throws StorageHubException {
        this.itemclient.delete(this.itemId, false);
        this.invalidateItem();
    }

    public void forceDelete() throws StorageHubException {
        this.itemclient.delete(this.itemId, true);
        this.invalidateItem();
    }

    public void rename(String newName) throws StorageHubException {
        this.itemclient.rename(this.getId(), newName);
        this.invalidateItem();
    }

    public void move(FolderContainer folder) throws StorageHubException {
        this.itemclient.move(this.getId(), folder.getId());
        this.invalidateItem();
    }

    public void setMetadata(Metadata metadata) throws StorageHubException {
        this.itemclient.setMetadata(this.getId(), metadata);
        this.invalidateItem();
    }

    public FolderContainer getRootSharedFolder() throws StorageHubException {
        return new FolderContainer(this.itemclient, (FolderItem)this.itemclient.getRootSharedFolder(this.itemId));
    }
}

