/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.storagehub.client.plugins;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.gcube.common.clients.Plugin;
import org.gcube.common.clients.ProxyBuilder;
import org.gcube.common.clients.ProxyBuilderImpl;
import org.gcube.common.clients.config.Property;
import org.gcube.common.storagehub.client.plugins.GroupManagerPlugin;
import org.gcube.common.storagehub.client.plugins.ItemManagerPlugin;
import org.gcube.common.storagehub.client.plugins.UserManagerPlugin;
import org.gcube.common.storagehub.client.plugins.WorkspaceManagerPlugin;
import org.gcube.common.storagehub.client.proxies.GroupManagerClient;
import org.gcube.common.storagehub.client.proxies.ItemManagerClient;
import org.gcube.common.storagehub.client.proxies.UserManagerClient;
import org.gcube.common.storagehub.client.proxies.WorkspaceManagerClient;

public abstract class AbstractPlugin<S, P>
implements Plugin<S, P> {
    private static final ItemManagerPlugin item_plugin = new ItemManagerPlugin();
    private static final WorkspaceManagerPlugin workspace_plugin = new WorkspaceManagerPlugin();
    private static final UserManagerPlugin user_plugin = new UserManagerPlugin();
    private static final GroupManagerPlugin group_plugin = new GroupManagerPlugin();
    public final String name;
    protected List<Class<?>> customClasses = Collections.emptyList();

    public static ProxyBuilder<ItemManagerClient> item() {
        return new ProxyBuilderImpl((Plugin)item_plugin, new Property[0]);
    }

    public static ProxyBuilder<GroupManagerClient> groups() {
        return new ProxyBuilderImpl((Plugin)group_plugin, new Property[0]);
    }

    public static ProxyBuilder<UserManagerClient> users() {
        return new ProxyBuilderImpl((Plugin)user_plugin, new Property[0]);
    }

    public static ProxyBuilder<WorkspaceManagerClient> workspace() {
        return new ProxyBuilderImpl((Plugin)workspace_plugin, new Property[0]);
    }

    public AbstractPlugin(String name) {
        this.name = name;
    }

    public String serviceClass() {
        return "DataAccess";
    }

    public String serviceName() {
        return "StorageHub";
    }

    public String namespace() {
        return "http://gcube-system.org/namespaces/common/storagehub";
    }

    public String name() {
        return this.name;
    }

    public void register(Class<?> ... _classes) {
        this.customClasses = Arrays.asList(_classes);
    }
}

