/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.storagehub.client.dsl;

import java.io.File;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.util.List;
import java.util.Set;
import org.gcube.common.storagehub.client.dsl.ContainerType;
import org.gcube.common.storagehub.client.dsl.FileContainer;
import org.gcube.common.storagehub.client.dsl.GenericItemContainer;
import org.gcube.common.storagehub.client.dsl.ItemContainer;
import org.gcube.common.storagehub.client.dsl.ListResolver;
import org.gcube.common.storagehub.client.dsl.ListResolverTyped;
import org.gcube.common.storagehub.client.dsl.OpenResolver;
import org.gcube.common.storagehub.client.dsl.URLContainer;
import org.gcube.common.storagehub.client.proxies.ItemManagerClient;
import org.gcube.common.storagehub.model.acls.ACL;
import org.gcube.common.storagehub.model.acls.AccessType;
import org.gcube.common.storagehub.model.exceptions.StorageHubException;
import org.gcube.common.storagehub.model.items.FolderItem;
import org.gcube.common.storagehub.model.items.GCubeItem;
import org.gcube.common.storagehub.model.items.Item;
import org.gcube.common.storagehub.model.plugins.PluginParameters;
import org.gcube.common.storagehub.model.types.FolderInfoType;

public class FolderContainer
extends ItemContainer<FolderItem> {
    protected FolderContainer(ItemManagerClient itemclient, FolderItem item) {
        super(itemclient, item);
    }

    protected FolderContainer(ItemManagerClient itemclient, String folderId) {
        super(itemclient, folderId);
    }

    @Override
    public ContainerType getType() {
        return ContainerType.FOLDER;
    }

    public ListResolverTyped list() throws StorageHubException {
        return new ListResolverTyped((onlyType, includeHidden, excludes) -> this.itemclient.getChildren(this.itemId, (Class<? extends Item>)onlyType, includeHidden, excludes), this.itemclient);
    }

    public FileContainer uploadFile(InputStream stream, String filename, String description) throws StorageHubException {
        return new FileContainer(this.itemclient, this.itemclient.uploadFile(stream, this.itemId, filename, description));
    }

    public FileContainer uploadFile(InputStream stream, String filename, String description, long size) throws StorageHubException {
        return new FileContainer(this.itemclient, this.itemclient.uploadFile(stream, this.itemId, filename, description, size));
    }

    public FileContainer uploadFile(File file, String description) throws StorageHubException {
        return new FileContainer(this.itemclient, this.itemclient.uploadFile(file, this.itemId, file.getName(), description));
    }

    public FileContainer uploadFile(URI uri, String name, String description) throws StorageHubException {
        return new FileContainer(this.itemclient, this.itemclient.uploadFile(uri, this.itemId, name, description));
    }

    public URLContainer addUrl(URL url, String name, String description) throws StorageHubException {
        return new URLContainer(this.itemclient, this.itemclient.createURL(this.itemId, name, description, url));
    }

    public FolderContainer uploadArchive(InputStream stream, String extractionFolderName) throws StorageHubException {
        return new FolderContainer(this.itemclient, this.itemclient.uploadArchive(stream, this.itemId, extractionFolderName));
    }

    public FolderContainer uploadArchive(InputStream stream, String extractionFolderName, long size) throws StorageHubException {
        return new FolderContainer(this.itemclient, this.itemclient.uploadArchive(stream, this.itemId, extractionFolderName, size));
    }

    public FolderContainer newFolder(String name, String description) throws StorageHubException {
        String newFolderId = this.itemclient.createFolder(this.itemId, name, description, false);
        return new FolderContainer(this.itemclient, newFolderId);
    }

    public FolderContainer newExternalFolder(String name, String description, boolean hidden, String storageName, PluginParameters storageParameters) throws StorageHubException {
        String newFolderId = this.itemclient.createFolder(this.itemId, name, description, false, storageName, storageParameters);
        return new FolderContainer(this.itemclient, newFolderId);
    }

    public FolderContainer newHiddenFolder(String name, String description) throws StorageHubException {
        String newFolderId = this.itemclient.createFolder(this.itemId, name, description, true);
        return new FolderContainer(this.itemclient, newFolderId);
    }

    public GenericItemContainer newGcubeItem(GCubeItem item) throws StorageHubException {
        String itemId = this.itemclient.createGcubeItem(this.itemId, item);
        return new GenericItemContainer(this.itemclient, itemId);
    }

    public List<ACL> getAcls() throws StorageHubException {
        return this.itemclient.getACL(this.itemId);
    }

    public FolderContainer changeAcls(String user, AccessType accessType) throws StorageHubException {
        this.itemclient.changeACL(this.itemId, user, accessType);
        return this;
    }

    public boolean canWrite() throws Exception {
        return this.itemclient.canWriteInto(this.itemId);
    }

    public ListResolver findByName(String namePattern) throws StorageHubException {
        return new ListResolver((onlyType, includeHidden, excludes) -> this.itemclient.findChildrenByNamePattern(this.itemId, namePattern, excludes), this.itemclient);
    }

    public OpenResolver openByRelativePath(String relativePath) throws StorageHubException {
        String id = this.itemId;
        return new OpenResolver(this.itemclient.getByRelativePath(id, relativePath, new String[0]), this.itemclient);
    }

    public ListResolver search(String nameTomatch, boolean excludeTrashed) throws StorageHubException {
        return new ListResolver((onlyType, includeHidden, excludes) -> this.itemclient.search(this.itemId, onlyType, includeHidden, excludeTrashed, nameTomatch, excludes), this.itemclient);
    }

    public ListResolver search(String nameTomatch) throws StorageHubException {
        return this.search(nameTomatch, true);
    }

    public FolderContainer share(Set<String> users, AccessType accessType) throws StorageHubException {
        this.itemclient.shareFolder(this.itemId, users, accessType);
        this.invalidateItem();
        return this;
    }

    public FolderContainer unshare(Set<String> users) throws Exception {
        String unsharedId = this.itemclient.unshareFolder(this.itemId, users);
        return new FolderContainer(this.itemclient, unsharedId);
    }

    public FolderContainer unpublish() throws Exception {
        this.itemclient.setPublic(this.itemId, false);
        this.invalidateItem();
        return this;
    }

    public FolderContainer publish() throws Exception {
        this.itemclient.setPublic(this.itemId, true);
        this.invalidateItem();
        return this;
    }

    public FolderInfoType info() throws Exception {
        return this.itemclient.getFolderInfo(this.itemId);
    }
}

