package org.gcube.common.storagehub.model.items;

import static org.gcube.common.storagehub.model.NodeConstants.ACCOUNTING_NAME;
import static org.gcube.common.storagehub.model.NodeConstants.METADATA_NAME;
import static org.gcube.common.storagehub.model.NodeConstants.OWNER_NAME;

import java.util.Calendar;

import org.gcube.common.storagehub.model.Metadata;
import org.gcube.common.storagehub.model.annotations.Attribute;
import org.gcube.common.storagehub.model.annotations.NodeAttribute;
import org.gcube.common.storagehub.model.items.nodes.Accounting;
import org.gcube.common.storagehub.model.items.nodes.Owner;
import org.gcube.common.storagehub.model.types.ItemAction;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;

import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;

@Getter
@Setter
@NoArgsConstructor
@JsonIgnoreProperties(ignoreUnknown = true)
public class Item extends RootItem{
	
	boolean trashed;
	
	@JsonIgnore
	boolean externalManaged = false;
	
	boolean shared;

	boolean locked;

	@Attribute("hl:isPublic")
	boolean publicItem;
	
	@Attribute(value ="jcr:title")
	String title;

	@Attribute("jcr:description")
	String description;

	@Attribute("jcr:lastModifiedBy")
	String lastModifiedBy;

	@Attribute("jcr:lastModified")
	Calendar lastModificationTime;

	@Attribute(value = "jcr:created", isReadOnly=true)
	Calendar creationTime;

	@Attribute("hl:portalLogin")
	String owner;

	@Attribute("hl:lastAction")
	ItemAction lastAction;
	
	@Attribute("hl:hidden")
	boolean hidden;
	
	@NodeAttribute(value=OWNER_NAME, isReadOnly=true)
	Owner ownerNode;
	
	@NodeAttribute(value=ACCOUNTING_NAME, isReadOnly=true)
	Accounting accounting;

	@NodeAttribute(value=METADATA_NAME)
	Metadata metadata = new Metadata();
		
	public String getOwner() {
		if (owner!=null) return owner;
		else if (ownerNode!=null) return ownerNode.getUserName();
		return null;
	}
	
}
