package org.gcube.common.storagehub.model.items;

import static org.gcube.common.storagehub.model.NodeConstants.PARAMETERS_NAME;

import org.gcube.common.storagehub.model.Metadata;
import org.gcube.common.storagehub.model.annotations.Attribute;
import org.gcube.common.storagehub.model.annotations.NodeAttribute;
import org.gcube.common.storagehub.model.annotations.RootNode;

import com.fasterxml.jackson.annotation.JsonIgnore;

import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;

@Getter
@Setter
@NoArgsConstructor
@RootNode("nthl:externalFolder")
public class ExternalFolder extends FolderItem {

	@Attribute("hl:pluginName")
	String managedBy;
	
	@JsonIgnore
	@NodeAttribute(value=PARAMETERS_NAME)
	Metadata connectionParameters = new Metadata();
}
