/*
 * Decompiled with CFR 0.152.
 */
package org.bitlet.wetorrent.peer.message;

import java.io.IOException;
import org.bitlet.wetorrent.disk.TorrentDisk;
import org.bitlet.wetorrent.peer.message.Message;
import org.bitlet.wetorrent.util.Utils;

public class Piece
extends Message {
    private int index;
    private int length;
    private int begin;
    private TorrentDisk torrentDisk;

    public Piece(int index, int begin, int length, TorrentDisk torrentDisk) {
        super((byte)7, null);
        this.torrentDisk = torrentDisk;
        this.index = index;
        this.length = length;
        this.begin = begin;
    }

    public int getIndex() {
        return this.index;
    }

    public int getLength() {
        return this.length;
    }

    public int getBegin() {
        return this.begin;
    }

    @Override
    public byte[] getPayload() {
        if (super.getPayload() == null) {
            try {
                byte[] block = this.torrentDisk.read(this.index, this.begin, this.length);
                byte[] payload = new byte[block.length + 8];
                System.arraycopy(block, 0, payload, 8, block.length);
                System.arraycopy(Utils.intToByteArray(this.index), 0, payload, 0, 4);
                System.arraycopy(Utils.intToByteArray(this.begin), 0, payload, 4, 4);
                this.setPayload(payload);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return super.getPayload();
    }
}

