/*
 * Decompiled with CFR 0.152.
 */
package org.bitlet.wetorrent.peer;

import java.io.DataInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.InetAddress;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.Random;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.bitlet.wetorrent.peer.Peer;
import org.bitlet.wetorrent.peer.PeersManager;
import org.bitlet.wetorrent.peer.message.Message;
import org.bitlet.wetorrent.peer.message.Request;
import org.bitlet.wetorrent.util.thread.InterruptableTasksThread;
import org.bitlet.wetorrent.util.thread.ThreadTask;

public class WebSeed
implements Peer {
    private URL url;
    private HttpURLConnection connection;
    private InterruptableTasksThread downloaderThread;
    private final BlockingQueue<Request> pendingRequests = new LinkedBlockingQueue<Request>();
    private static final Request requestEnd = new Request(Integer.MAX_VALUE, 0, 0);
    private PeersManager peersManager;
    private byte[] peerId = new byte[20];
    private byte[] bitfield;
    private long downloaded = 0L;
    static FileOutputStream fos;
    static int wrote;
    static final int TOT_SIZE = 3576986;

    public WebSeed(URL url, PeersManager peersManager) {
        this.url = url;
        this.peersManager = peersManager;
        this.bitfield = peersManager.getTorrent().getTorrentDisk().getBitfieldCopy();
        int i = 0;
        while (i < this.bitfield.length) {
            int n = i++;
            this.bitfield[n] = (byte)(this.bitfield[n] | 0xFF);
        }
        Random random = new Random(System.currentTimeMillis());
        random.nextBytes(this.peerId);
        System.arraycopy("-WT-HTTP".getBytes(), 0, this.peerId, 0, 8);
        this.downloaderThread = new InterruptableTasksThread();
        this.downloaderThread.addTask(new HttpRangeDownloader());
    }

    public void requestEnd() {
        this.pendingRequests.add(requestEnd);
    }

    public void start() {
        this.downloaderThread.start();
    }

    @Override
    public void interrupt() {
        this.downloaderThread.interrupt();
    }

    @Override
    public void sendMessage(Message message) {
        if (message.getType() == 6) {
            this.pendingRequests.add((Request)message);
        }
    }

    @Override
    public void setAmInterested(boolean b) {
        this.peersManager.getTorrent().unchoke(this);
    }

    @Override
    public void setIsChoked(boolean b) {
    }

    @Override
    public long getDownloaded() {
        return this.downloaded;
    }

    @Override
    public InetAddress getIp() {
        InetAddress ia = null;
        try {
            ia = InetAddress.getByName(this.url.getHost());
        }
        catch (UnknownHostException ex) {
            Logger.getLogger(WebSeed.class.getName()).log(Level.SEVERE, null, ex);
        }
        return ia;
    }

    @Override
    public int getPort() {
        return this.url.getPort();
    }

    @Override
    public byte[] getPeerId() {
        return this.peerId;
    }

    @Override
    public long getLastReceivedMessageMillis() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public int getUnfulfilledRequestNumber() {
        return this.pendingRequests.size();
    }

    @Override
    public long getUploaded() {
        return 0L;
    }

    @Override
    public boolean hasPiece(int index) {
        return true;
    }

    @Override
    public boolean isAmChoked() {
        return false;
    }

    @Override
    public boolean isSeeder() {
        return true;
    }

    private void byteSink(byte[] stuff) throws Exception {
        fos.write(stuff);
        System.out.println("wrote: " + (wrote += stuff.length));
        if (wrote == 3576986) {
            fos.close();
        }
    }

    static {
        wrote = 0;
    }

    class HttpRangeDownloader
    implements ThreadTask {
        HttpRangeDownloader() {
        }

        @Override
        public boolean execute() throws Exception {
            Request nextRequest = (Request)WebSeed.this.pendingRequests.take();
            if (nextRequest != requestEnd) {
                byte[] range = this.downloadRange(nextRequest);
                WebSeed.this.byteSink(range);
                return true;
            }
            return false;
        }

        @Override
        public void interrupt() {
            try {
                WebSeed.this.pendingRequests.put(requestEnd);
            }
            catch (InterruptedException ex) {
                Logger.getLogger(WebSeed.class.getName()).log(Level.SEVERE, null, ex);
            }
        }

        public void exceptionCaught(Exception e) {
            e.printStackTrace();
        }

        @Override
        @Deprecated
        public void exceptionCought(Exception e) {
            this.exceptionCaught(e);
        }

        private byte[] downloadRange(Request request) throws IOException {
            byte[] result = new byte[request.getLength()];
            WebSeed.this.connection = (HttpURLConnection)WebSeed.this.url.openConnection();
            WebSeed.this.connection.setRequestProperty("Connection", "Keep-Alive");
            WebSeed.this.connection.setRequestProperty("Range", "bytes=" + request.getBegin() + "-" + (request.getBegin() + request.getLength() - 1));
            System.out.println("Range: bytes=" + request.getBegin() + "-" + (request.getBegin() + request.getLength() - 1));
            WebSeed.this.connection.connect();
            int response = WebSeed.this.connection.getResponseCode();
            DataInputStream is = new DataInputStream(WebSeed.this.connection.getInputStream());
            if (response == 202 || response == 200 || response == 206) {
                is.readFully(result, 0, request.getLength());
            }
            is.close();
            return result;
        }
    }
}

