/*
 * Decompiled with CFR 0.152.
 */
package org.bitlet.wetorrent.util.thread;

import java.util.LinkedList;
import java.util.Queue;
import org.bitlet.wetorrent.util.thread.ThreadTask;

public class InterruptableTasksThread
extends Thread {
    Queue<ThreadTask> tasks = new LinkedList<ThreadTask>();
    ThreadTask currentTask = null;
    private boolean closing = false;

    public InterruptableTasksThread() {
    }

    public InterruptableTasksThread(String name) {
        super(name);
    }

    public synchronized void addTask(ThreadTask task) {
        this.tasks.add(task);
        if (this.tasks.size() == 1) {
            this.notify();
        }
    }

    @Override
    public void run() {
        ThreadTask currentTask = this.nextTask();
        while (!this.isClosing() && currentTask != null) {
            try {
                if (currentTask.execute()) continue;
                currentTask = this.nextTask();
            }
            catch (Exception e) {
                this.closing = true;
                currentTask.exceptionCought(e);
            }
        }
    }

    public synchronized ThreadTask nextTask() {
        this.currentTask = null;
        while (!this.isClosing() && (this.currentTask = this.tasks.poll()) == null) {
            try {
                this.wait();
            }
            catch (InterruptedException ex) {
                this.closing = true;
            }
        }
        return this.currentTask;
    }

    public synchronized ThreadTask getCurrentTask() {
        return this.currentTask;
    }

    @Override
    public synchronized void interrupt() {
        if (this.currentTask != null) {
            this.currentTask.interrupt();
        }
        this.closing = true;
        this.notify();
    }

    public synchronized boolean isClosing() {
        return this.closing;
    }
}

