/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.content.storage.rest.service;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.bson.Document;
import org.bson.types.ObjectId;
import org.gcube.content.storage.rest.bean.Credentials;
import org.gcube.content.storage.rest.bean.Resource;
import org.gcube.content.storage.rest.utils.Utils;
import org.gcube.mongodb.access.GCubeClient;
import org.gcube.mongodb.driver.MongoClientInstance;
import org.gcube.mongodb.driver.MongoConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceService {
    static HashMap<Integer, Resource> resourceIdMap = ResourceService.getResourceIdMap();
    private String db;
    Credentials credentials;
    private String token;
    MongoClientInstance instance;
    MongoClientInstance sharedInstance;
    Credentials sharedCredentials;
    private static final Logger logger = LoggerFactory.getLogger(ResourceService.class);

    public ResourceService(String token) {
        this.token = token;
    }

    public MongoClientInstance loadContext(String token) {
        logger.trace("loadContext method");
        GCubeClient gcube = new GCubeClient("DataStorage", "SmartStorageREST");
        this.db = gcube.retrieveDBEnabled(Utils.getTokenId((String)token));
        this.credentials = gcube.getCredentials(this.db, Utils.getTokenId((String)token));
        Utils.printCredentials((Credentials)this.credentials);
        MongoConfiguration configuration = new MongoConfiguration(this.credentials.getUser(), this.credentials.getPwd(), this.credentials.getDb(), this.credentials.getServers(), null);
        this.instance = MongoClientInstance.getInstance((MongoConfiguration)configuration);
        return this.instance;
    }

    public List<String> getAllResources() {
        this.instance = this.loadContext(this.token);
        List resources = this.instance.find(this.credentials.getDb(), this.credentials.getCollection());
        if (resources != null && !resources.isEmpty()) {
            ArrayList<String> jsons = new ArrayList<String>(resources.size());
            for (Document doc : resources) {
                jsons.add(doc.toJson());
            }
            return jsons;
        }
        return null;
    }

    public String getResource(String id) {
        this.instance = this.loadContext(this.token);
        Document doc = this.instance.findById(this.credentials.getDb(), this.credentials.getCollection(), id);
        return doc.toJson();
    }

    public String getResource(String name, String value) {
        this.instance = this.loadContext(this.token);
        Document doc = this.instance.findOne(this.credentials.getDb(), this.credentials.getCollection(), name, (Object)value);
        return doc.toJson();
    }

    public String addResource(String resource) {
        this.instance = this.loadContext(this.token);
        Document doc = Document.parse((String)resource);
        if (doc.get((Object)"_id") == null) {
            logger.debug("id present on POST operation");
            ObjectId id = new ObjectId();
            doc.append("_id", (Object)id);
            logger.debug("new id generated: " + id);
        }
        this.instance.insertOne(this.credentials.getDb(), this.credentials.getCollection(), doc);
        this.insertIntoSharedContext(doc);
        return resource;
    }

    public String updateResource(String id, String resource) {
        logger.info("updating resource with id: " + id);
        this.instance = this.loadContext(this.token);
        this.instance.update(this.credentials.getDb(), this.credentials.getCollection(), id, resource);
        this.updateIntoSharedContext(id, resource);
        return resource;
    }

    public void deleteResource(int id) {
        resourceIdMap.remove(id);
    }

    public static HashMap<Integer, Resource> getResourceIdMap() {
        return resourceIdMap;
    }

    private void insertIntoSharedContext(Document doc) {
        MongoClientInstance instance = this.loadSharedContext();
        instance.insertOne(this.sharedCredentials.getDb(), this.sharedCredentials.getCollection(), doc);
    }

    private void updateIntoSharedContext(String id, String resource) {
        MongoClientInstance instance = this.loadSharedContext();
        instance.update(this.sharedCredentials.getDb(), this.sharedCredentials.getCollection(), id, resource);
    }

    private MongoClientInstance loadSharedContext() {
        if (this.sharedInstance == null) {
            logger.trace("loadSharedContext method");
            GCubeClient gcube = new GCubeClient("DataStorage", "SmartStorageREST");
            String dbName = gcube.retrieveDBEnabled("All-In-Db");
            this.sharedCredentials = gcube.getCredentials(dbName, "collectionName");
            Utils.printCredentials((Credentials)this.sharedCredentials);
            MongoConfiguration configuration = new MongoConfiguration(this.sharedCredentials.getUser(), this.sharedCredentials.getPwd(), this.sharedCredentials.getDb(), this.sharedCredentials.getServers(), null);
            this.sharedInstance = MongoClientInstance.getInstance((MongoConfiguration)configuration);
        }
        return this.sharedInstance;
    }
}

