/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.aquamaps.aquamapstransectgenerator.databases;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.gcube.application.aquamaps.aquamapstransectgenerator.databases.DBprocessing;
import org.gcube.contentmanagement.lexicalmatcher.utils.AnalysisLogger;
import org.gcube.contentmanagement.lexicalmatcher.utils.DatabaseFactory;
import org.hibernate.SessionFactory;

public class DBPostGISExtractror {
    private SessionFactory dbSession;
    private static final String hibFile = "GeoHibernate.cfg.xml";
    static final String extractionQuery = "select csquarecode,cntry_name from new_all_world s where (intersects(s.the_geom, ST_GeomFromText('LINESTRING(%1$s %2$s, %3$s %4$s)',%5$s)));";
    static final String completeExtractionQuery = "select distinct ss.csquarecode,d.%7$s,ss.cntry_name from (select csquarecode,cntry_name from new_all_world s where (intersects(s.the_geom, ST_GeomFromText('LINESTRING(%1$s %2$s, %3$s %4$s)',%5$s)))) ss left join %6$s d on (d.csquarecode=ss.csquarecode);";
    private LinkedHashMap<String, Double> bioValues;
    public Map<String, String> countryNames;
    static final String biodiversityQuery = "select distinct f.\"%1$s\",f.\"csquarecode\" from %2$s f where (%3$s);";
    static final String whereQuery = "csquarecode='%1$s'";

    public void setDbSession(SessionFactory dbSession) {
        this.dbSession = dbSession;
    }

    public SessionFactory getDbSession() {
        return this.dbSession;
    }

    public DBPostGISExtractror(String cfg) {
        try {
            this.dbSession = DatabaseFactory.initDBConnection((String)(cfg + hibFile));
        }
        catch (Exception e) {
            AnalysisLogger.getLogger().error((Object)("Error in starting connection to PostGIS " + e.getLocalizedMessage()));
        }
    }

    public List<String> getAllInfo(String x1, String y1, String x2, String y2, String SRID, String tableName, String fieldName) {
        ArrayList<String> cSquareCodes = new ArrayList<String>();
        this.bioValues = new LinkedHashMap();
        this.countryNames = new HashMap<String, String>();
        String selectQuery = String.format(completeExtractionQuery, x1, y1, x2, y2, SRID, tableName, fieldName);
        AnalysisLogger.getLogger().debug((Object)("Executing PostGIS query: " + selectQuery));
        try {
            List resultSet = DatabaseFactory.executeSQLQuery((String)selectQuery, (SessionFactory)this.dbSession);
            int c = 0;
            for (Object result : resultSet) {
                Double value;
                Object[] resultArray = (Object[])result;
                String square = (String)resultArray[0];
                try {
                    value = (Double)resultArray[1];
                }
                catch (Exception e1) {
                    try {
                        value = ((Float)resultArray[1]).doubleValue();
                    }
                    catch (Exception e2) {
                        value = ((Integer)resultArray[1]).doubleValue();
                    }
                }
                if (value == null) {
                    value = 0.0;
                }
                String country_name = (String)resultArray[2];
                this.bioValues.put(square, (double)value);
                cSquareCodes.add(square);
                if (country_name != null) {
                    this.countryNames.put(square, country_name);
                }
                ++c;
            }
        }
        catch (Exception e) {
            AnalysisLogger.getLogger().debug((Object)("DBPostGISExtractror-> Error in getting info from DB: " + e.getLocalizedMessage()));
        }
        return cSquareCodes;
    }

    public Map<String, Double> getCalculatedBioValues() {
        return this.bioValues;
    }

    public List<String> getCSquareCodes(String x1, String y1, String x2, String y2, String SRID) {
        ArrayList<String> cSquareCodes = new ArrayList<String>();
        this.countryNames = new HashMap<String, String>();
        String selectQuery = String.format(extractionQuery, x1, y2, x2, y2, SRID);
        AnalysisLogger.getLogger().debug((Object)("Executing PostGIS query: " + selectQuery));
        try {
            List resultSet = DatabaseFactory.executeSQLQuery((String)selectQuery, (SessionFactory)this.dbSession);
            for (Object result : resultSet) {
                Object[] resultArray = (Object[])result;
                String square = (String)resultArray[0];
                String countryName = (String)resultArray[0];
                this.countryNames.put(square, countryName);
                cSquareCodes.add(square);
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return cSquareCodes;
    }

    public Map<String, Double> getBioDiversity(String bioDivTable, String bioDivField, List<String> cSquareCodes) {
        LinkedHashMap<String, Double> bioValues = new LinkedHashMap<String, Double>();
        String selectQuery = String.format(biodiversityQuery, bioDivField, bioDivTable, DBprocessing.buildWhereQuery(cSquareCodes, whereQuery));
        AnalysisLogger.getLogger().debug((Object)("Executing PostGIS query: " + selectQuery));
        List resultSet = DatabaseFactory.executeSQLQuery((String)selectQuery, (SessionFactory)this.dbSession);
        if (resultSet != null) {
            for (Object result : resultSet) {
                Object[] resultArray = (Object[])result;
                Double value = (Double)resultArray[0];
                String cell = (String)resultArray[1];
                bioValues.put(cell, (double)value);
            }
        }
        return bioValues;
    }
}

