/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.aquamaps.aquamapstransectgenerator.databases;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.gcube.application.aquamaps.aquamapstransectgenerator.databases.DBprocessing;
import org.gcube.contentmanagement.lexicalmatcher.utils.AnalysisLogger;
import org.gcube.contentmanagement.lexicalmatcher.utils.DatabaseFactory;
import org.hibernate.SessionFactory;

public class DBAquamapsExtractor {
    private SessionFactory dbSession;
    private static final String hibFile = "AquamapsHibernate.cfg.xml";
    private HashMap<Integer, String> FAOAreasNames;
    private HashMap<Integer, String> EEZAreasNames;
    private HashMap<Integer, String> LMEAreasNames;
    private static final String areasNamesQuery = "SELECT code,name,type FROM area where code IS NOT NULL";
    private static final String nationsQuery = "SELECT countryname FROM countriessquares c where csquarecode ='%1$s'";
    static final String extractionQuery = "SELECT CSquareCode,CenterLat,CenterLong,EEZFirst,FAOAreaM FROM hcaf_s h where (%1$s) order by CenterLong;";
    static final String whereQuery = " CSquareCode='%1$s' ";
    LinkedHashMap<String, String> areasCodes = new LinkedHashMap();

    public void setDbSession(SessionFactory dbSession) {
        this.dbSession = dbSession;
    }

    public SessionFactory getDbSession() {
        return this.dbSession;
    }

    public DBAquamapsExtractor(String cfg) {
        try {
            this.dbSession = DatabaseFactory.initDBConnection((String)(cfg + hibFile));
        }
        catch (Exception e) {
            AnalysisLogger.getLogger().error((Object)("Error in starting connection to Aquamaps " + e.getLocalizedMessage()));
        }
        this.FAOAreasNames = new HashMap();
        this.EEZAreasNames = new HashMap();
        this.LMEAreasNames = new HashMap();
        AnalysisLogger.getLogger().error((Object)"DBAquamapsExtractor->Retrieving info about Areas");
        this.fillAreas();
    }

    private void fillAreas() {
        try {
            List resultSet = DatabaseFactory.executeSQLQuery((String)areasNamesQuery, (SessionFactory)this.dbSession);
            for (Object result : resultSet) {
                Object[] resultArray = (Object[])result;
                Integer code = Integer.parseInt((String)resultArray[0]);
                String name = (String)resultArray[1];
                String type = (String)resultArray[2];
                if (type.equalsIgnoreCase("FAO")) {
                    this.FAOAreasNames.put(code, name);
                    continue;
                }
                if (type.equalsIgnoreCase("LME")) {
                    this.LMEAreasNames.put(code, name);
                    continue;
                }
                if (!type.equalsIgnoreCase("EEZ")) continue;
                this.EEZAreasNames.put(code, name);
            }
        }
        catch (Exception e) {
            AnalysisLogger.getLogger().error((Object)"DBAquamapsExtractor-> Error in getting Areas or missing AREA table");
        }
    }

    public Map<String, String> getLongLatBioDiversity(List<String> csquarecodes, Map<String, String> areaNames) {
        LinkedHashMap<String, String> longlatcouples = new LinkedHashMap<String, String>();
        String selectQuery = String.format(extractionQuery, DBprocessing.buildWhereQuery(csquarecodes, whereQuery));
        AnalysisLogger.getLogger().debug((Object)("Executing query on Aquamaps: " + selectQuery));
        List resultSet = DatabaseFactory.executeSQLQuery((String)selectQuery, (SessionFactory)this.dbSession);
        for (Object result : resultSet) {
            Object[] resultArray = (Object[])result;
            String code = "" + resultArray[0];
            String Lat$ = "" + resultArray[1];
            String Long$ = "" + resultArray[2];
            String couple = "(" + Lat$ + "," + Long$ + ")";
            String area = "";
            if (resultArray[3] != null) {
                area = this.EEZAreasNames.get(resultArray[3]);
            }
            if (area == null || area.length() == 0) {
                String FAOAr = this.FAOAreasNames.get(resultArray[4]);
                if (FAOAr != null) {
                    area = "FAO_" + FAOAr;
                } else {
                    area = areaNames == null ? this.getNation(code) : areaNames.get(code);
                    if (area == null) {
                        area = "FAOArea_LAND";
                    }
                }
            }
            longlatcouples.put(code, couple);
            this.areasCodes.put(couple, area);
        }
        return longlatcouples;
    }

    public String getNation(String csquarecode) {
        String nation = null;
        try {
            List resultSet = DatabaseFactory.executeSQLQuery((String)String.format(nationsQuery, csquarecode), (SessionFactory)this.dbSession);
            if (resultSet.size() > 0) {
                nation = (String)resultSet.get(0);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return nation;
    }

    public List<String> getAreaAnotations(List<String> couples) {
        ArrayList<String> anotations = new ArrayList<String>();
        for (String couple : couples) {
            anotations.add(this.areasCodes.get(couple));
        }
        return anotations;
    }
}

