/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.contentmanagement.codelistmanager.util.csv;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import net.sf.csv4j.CSVLineProcessor;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.common.dbinterface.ColumnDefinition;
import org.gcube.common.dbinterface.Specification;
import org.gcube.common.dbinterface.pool.DBSession;
import org.gcube.common.dbinterface.types.Type;
import org.gcube.contentmanagement.codelistmanager.entities.TableField;
import org.gcube.contentmanagement.codelistmanager.util.csv.ImportUtil;

public class InitializerProcessor
implements CSVLineProcessor {
    private static GCUBELog logger = new GCUBELog(InitializerProcessor.class);
    private boolean tableCreated = false;
    private List<ColumnDefinition> tableDefinition = new ArrayList<ColumnDefinition>();
    private Hashtable<String, TableField> fieldsName;
    private int totalLines = 0;

    public List<ColumnDefinition> getTableDefinition() {
        return this.tableDefinition;
    }

    public Hashtable<String, TableField> getFieldNames() {
        return this.fieldsName;
    }

    public int getTotalLines() {
        return this.totalLines;
    }

    public void processHeaderLine(int lineNumber, List<String> fields) {
        this.onHeaderLine(lineNumber, fields);
    }

    public void processDataLine(int lineNumber, List<String> fields) {
        this.onDataLine(lineNumber, fields);
    }

    public boolean continueProcessing() {
        return true;
    }

    public void onHeaderLine(int lineNumber, List<String> fields) {
        try {
            ColumnDefinition colDef = (ColumnDefinition)DBSession.getImplementation(ColumnDefinition.class);
            colDef.setLabel("ID");
            colDef.setType(new Type(Type.Types.INTEGER, new int[]{8}));
            colDef.setSpecification(new Specification[]{Specification.NOT_NULL, Specification.AUTO_INCREMENT});
            this.tableDefinition.add(colDef);
            this.fieldsName = new Hashtable();
            for (int i = 0; i < fields.size(); ++i) {
                ColumnDefinition columnDef = (ColumnDefinition)DBSession.getImplementation(ColumnDefinition.class);
                columnDef.setLabel("field" + i);
                columnDef.setType(new Type(Type.Types.STRING, new int[]{1, 0}));
                if (fields != null && fields.get(i) != "") {
                    this.fieldsName.put("field" + i, new TableField("field" + i, fields.get(i), Type.Types.STRING));
                } else {
                    this.fieldsName.put("field" + i, new TableField("field" + i, "field" + i, Type.Types.STRING));
                }
                this.tableDefinition.add(columnDef);
            }
            this.tableCreated = true;
        }
        catch (Exception e) {
            logger.error((Object)"erorr reading the header line", (Throwable)e);
        }
    }

    public void onDataLine(int lineNumber, List<String> fields) {
        try {
            if (!this.tableCreated) {
                ColumnDefinition colDef = (ColumnDefinition)DBSession.getImplementation(ColumnDefinition.class);
                colDef.setLabel("ID");
                colDef.setType(new Type(Type.Types.INTEGER, new int[]{8}));
                colDef.setSpecification(new Specification[]{Specification.NOT_NULL, Specification.AUTO_INCREMENT});
                this.tableDefinition.add(colDef);
                this.fieldsName = new Hashtable();
                for (int i = 0; i < fields.size(); ++i) {
                    ColumnDefinition columnDef = (ColumnDefinition)DBSession.getImplementation(ColumnDefinition.class);
                    columnDef.setLabel("field" + i);
                    columnDef.setType(new Type(Type.Types.STRING, new int[]{1, 0}));
                    this.tableDefinition.add(columnDef);
                    this.fieldsName.put("field" + i, new TableField("field" + i, "field" + i, Type.Types.STRING));
                }
                this.tableCreated = true;
            }
            for (int i = 0; i < fields.size(); ++i) {
                if (fields.get(i).length() > this.tableDefinition.get(i + 1).getType().getPrecisionArray()[0]) {
                    this.tableDefinition.get((int)(i + 1)).getType().getPrecisionArray()[0] = fields.get(i).length();
                    this.fieldsName.get((Object)this.tableDefinition.get((int)(i + 1)).getLabel()).getLength()[0] = fields.get(i).length();
                }
                if (ImportUtil.getAfterDotLength(fields.get(i)) <= this.tableDefinition.get(i + 1).getType().getPrecisionArray()[1]) continue;
                this.tableDefinition.get((int)(i + 1)).getType().getPrecisionArray()[1] = ImportUtil.getAfterDotLength(fields.get(i));
                this.fieldsName.get((Object)this.tableDefinition.get((int)(i + 1)).getLabel()).getLength()[1] = ImportUtil.getAfterDotLength(fields.get(i));
            }
            ++this.totalLines;
        }
        catch (Exception e) {
            logger.error((Object)"error reading data line", (Throwable)e);
        }
    }
}

