/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.contentmanagement.codelistmanager.util.csv;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Hashtable;
import java.util.List;
import net.sf.csv4j.CSVLineProcessor;
import net.sf.csv4j.CSVReaderProcessor;
import org.gcube.common.dbinterface.ColumnDefinition;
import org.gcube.common.dbinterface.tables.SimpleTable;
import org.gcube.contentmanagement.codelistmanager.entities.TableField;
import org.gcube.contentmanagement.codelistmanager.util.ImporterInterface;
import org.gcube.contentmanagement.codelistmanager.util.csv.ImportLineProcessor;
import org.gcube.contentmanagement.codelistmanager.util.csv.InitializerProcessor;
import org.gcube.contentmanagement.codelistmanager.util.csv.ProgresChangedEvent;

public class CSVImport
extends ImporterInterface {
    private File csvFile;
    protected boolean hasHeader = true;
    protected char delimiter = (char)44;
    protected String encoding;
    protected int totalLines = -1;
    protected InitializerProcessor initializer;
    protected ImportLineProcessor lineProcessor;

    public CSVImport(File csvFile, boolean hasHeader, char delimiter, String encoding, InitializerProcessor initializer, ImportLineProcessor lineprocessor) {
        this.csvFile = csvFile;
        this.hasHeader = hasHeader;
        this.delimiter = delimiter;
        this.encoding = encoding;
        this.initializer = initializer;
        this.lineProcessor = lineprocessor;
    }

    @Override
    public void initialize() throws Exception {
        CSVReaderProcessor processor = new CSVReaderProcessor();
        processor.setDelimiter(this.delimiter);
        processor.setHasHeader(this.hasHeader);
        processor.processStream((Reader)new InputStreamReader((InputStream)new FileInputStream(this.csvFile), this.encoding), (CSVLineProcessor)this.initializer);
        this.totalLines = this.initializer.getTotalLines();
    }

    @Override
    public void process(SimpleTable table, ProgresChangedEvent event) throws Exception {
        CSVReaderProcessor processor = new CSVReaderProcessor();
        processor.setDelimiter(this.delimiter);
        processor.setHasHeader(this.hasHeader);
        this.lineProcessor.setTable(table);
        this.lineProcessor.setEvent(event);
        processor.processStream((Reader)new InputStreamReader((InputStream)new FileInputStream(this.csvFile), this.encoding), (CSVLineProcessor)this.lineProcessor);
    }

    @Override
    public int getTotalLines() {
        return this.totalLines;
    }

    @Override
    public List<ColumnDefinition> getTableDefinition() {
        if (this.initializer == null) {
            return null;
        }
        return this.initializer.getTableDefinition();
    }

    @Override
    public Hashtable<String, TableField> getFieldsName() {
        if (this.initializer == null) {
            return null;
        }
        return this.initializer.getFieldNames();
    }
}

