/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.contentmanagement.util.configuration;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.log4j.Logger;
import org.gcube.common.core.contexts.GCUBEServiceContext;
import org.gcube.contentmanagement.util.configuration.BasicConfigurationConstantsNames;
import org.gcube.contentmanagement.util.configuration.ConfigurationConstantsNames;

public class Configuration
extends Properties {
    static Logger logger = Logger.getLogger(Configuration.class);
    public static final String DEFAULT_CONTEXT = "default-context";
    private static ContextProvider contextProvider = new DefaultContextProvider();
    private static Map<String, Configuration> configurations = new HashMap<String, Configuration>();

    public static void setContextProvider(ContextProvider contextProvider) {
        Configuration.contextProvider = contextProvider;
    }

    public static Configuration getConfiguration(String contextID) {
        if (!configurations.containsKey(contextID)) {
            configurations.put(contextID, new Configuration());
            logger.debug((Object)("new configuration for context " + contextID + " created"));
        }
        return configurations.get(contextID);
    }

    public static Configuration getConfiguration() {
        return Configuration.getConfiguration(contextProvider.getContextID());
    }

    public static String getContextID() {
        return contextProvider.getContextID();
    }

    public String getProperty(String propName) {
        logger.debug((Object)("getting property:" + propName));
        if (!this.containsKey(propName)) {
            if (Configuration.getConfiguration(DEFAULT_CONTEXT).containsKey(propName)) {
                return Configuration.getConfiguration(DEFAULT_CONTEXT).getProperty(propName);
            }
            logger.debug((Object)("property:" + propName + "not defined locally!!"));
            return null;
        }
        return super.getProperty(propName);
    }

    public int getIntProperty(String propName) {
        return Integer.parseInt(this.getProperty(propName));
    }

    public String getProperty(ConfigurationConstantsNames propName) {
        return this.getProperty(propName.name());
    }

    public int getIntProperty(ConfigurationConstantsNames propName) {
        return this.getIntProperty(propName.name());
    }

    public void setProperty(ConfigurationConstantsNames propName, String value) {
        logger.info((Object)("Setting value for property:" + propName + ":" + value));
        this.setProperty(propName.name(), value);
    }

    public File getFileProperty(String name) {
        return new File(this.getProperty(name));
    }

    public File getFileProperty(ConfigurationConstantsNames propName) {
        return this.getFileProperty(propName.name());
    }

    public void loadFromServiceContext(GCUBEServiceContext context, ConfigurationConstantsNames[] constantNamesValues) {
        for (ConfigurationConstantsNames constant : constantNamesValues) {
            Object dynProperty = context.getProperty(constant.name(), new boolean[]{false});
            if (dynProperty != null && dynProperty instanceof String) {
                logger.info((Object)("Found property value in context:" + constant.name() + ":" + dynProperty));
                this.setProperty(constant.name(), (String)dynProperty);
                continue;
            }
            if (constant.hasDefaultValue()) {
                logger.info((Object)("Setting default value for property:" + constant.name() + ":" + constant.getDefaultValue()));
                this.setProperty(constant.name(), constant.getDefaultValue());
                continue;
            }
            logger.warn((Object)("Configuration constant " + constant.name() + " has no default value and no value in context"));
        }
    }

    static {
        Configuration c = new Configuration();
        for (BasicConfigurationConstantsNames constant : BasicConfigurationConstantsNames.values()) {
            if (!constant.hasDefaultValue()) continue;
            logger.info((Object)("Setting default value for property:" + constant.name() + ":" + constant.getDefaultValue()));
            c.setProperty(constant.name(), constant.getDefaultValue());
        }
        configurations.put(DEFAULT_CONTEXT, c);
    }

    public static class DefaultContextProvider
    implements ContextProvider {
        public String getContextID() {
            return Configuration.DEFAULT_CONTEXT;
        }
    }

    public static interface ContextProvider {
        public String getContextID();
    }
}

