/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.contentmanagement.contentmanager.stubs.calls.iterators;

import java.net.URI;
import java.util.Iterator;
import org.gcube.contentmanagement.contentmanager.stubs.calls.iterators.AsyncRSIterator;
import org.gcube.contentmanagement.contentmanager.stubs.calls.iterators.FaultListener;
import org.gcube.contentmanagement.contentmanager.stubs.calls.iterators.ResultParser;

public class RSCollection<T>
implements Iterable<T> {
    private static final int DEFAULT_TIMEOUT = 30;
    private FaultListener listener;
    private URI locator;
    private ResultParser<T> parser;
    private int timeout;

    public RSCollection(URI l, ResultParser<T> p) throws Exception {
        this(l, p, 30);
    }

    public RSCollection(URI l, ResultParser<T> p, int timeout) throws Exception {
        this.locator = l;
        this.parser = p;
        this.timeout = timeout;
    }

    public RSCollection(URI l, ResultParser<T> p, FaultListener fl) throws Exception {
        this(l, p, 30, fl);
    }

    public RSCollection(URI l, ResultParser<T> p, int timeout, FaultListener fl) throws Exception {
        this.locator = l;
        this.parser = p;
        this.listener = fl;
        this.timeout = timeout;
    }

    public URI getLocator() {
        return this.locator;
    }

    public void setListener(FaultListener fl) {
        this.listener = fl;
    }

    @Override
    public Iterator<T> iterator() throws RuntimeException {
        try {
            return this.listener == null ? new AsyncRSIterator<T>(this.locator, this.parser, this.timeout) : new AsyncRSIterator<T>(this.locator, this.parser, this.timeout, this.listener);
        }
        catch (Exception e) {
            throw new RuntimeException("could not create RS iterator", e);
        }
    }
}

